/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.list;

import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import com.jsql.view.swing.list.DnDList;
import com.jsql.view.swing.list.ItemList;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MenuActionExport
implements ActionListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private DnDList myList;

    public MenuActionExport(DnDList myList) {
        this.myList = myList;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        JFileChooser importFileDialog = new JFileChooser(MediatorHelper.model().getMediatorUtils().getPreferencesUtil().getPathFile()){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                if (file.exists() && this.getDialogType() == 1) {
                    int replace = JOptionPane.showConfirmDialog(this, String.format("%s %s", file.getName(), I18nUtil.valueByKey("LIST_EXPORT_CONFIRM_LABEL")), I18nUtil.valueByKey("LIST_EXPORT_CONFIRM_TITLE"), 0);
                    switch (replace) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case -1: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                } else {
                    super.approveSelection();
                }
            }
        };
        importFileDialog.setDialogTitle(I18nUtil.valueByKey("LIST_EXPORT_TITLE"));
        int choice = importFileDialog.showSaveDialog(this.myList.getTopLevelAncestor());
        if (choice != 0) {
            return;
        }
        try (FileOutputStream file = new FileOutputStream(importFileDialog.getSelectedFile());
             PrintStream out = new PrintStream(file);){
            int len = this.myList.getModel().getSize();
            for (int i = 0; i < len; ++i) {
                out.println(((ItemList)this.myList.getModel().getElementAt(i)).toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

