/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.action;

import com.jsql.MainApplication;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActionNewWindow
extends AbstractAction {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String CLASSPATH = System.getProperty("java.class.path");
    private static final String PATH = System.getProperty("java.home") + SEPARATOR + "bin" + SEPARATOR + "java";
    private static final List<String> COMMANDS_DEFAULT = Arrays.asList("-cp", CLASSPATH, MainApplication.class.getName());
    private List<String> commands = new ArrayList<String>(Arrays.asList(PATH));

    public ActionNewWindow() {
        this(I18nUtil.valueByKey("NEW_WINDOW_MENU"), new String[0]);
        this.putValue("MnemonicKey", 78);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
    }

    public ActionNewWindow(String name, String ... commands) {
        this.commands.addAll(Arrays.asList(commands));
        this.commands.addAll(COMMANDS_DEFAULT);
        this.putValue("Name", name);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        LOGGER.log(LogLevel.CONSOLE_INFORM, () -> I18nUtil.valueByKey("NEW_WINDOW_START"));
        ProcessBuilder processBuilder = new ProcessBuilder(this.commands.toArray(new String[0]));
        try {
            processBuilder.start();
        }
        catch (IOException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

