/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util.protocol;

import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SessionCookieManager
extends CookieHandler {
    private CookiePolicy policyCallback;
    private static final ThreadLocal<CookieStore> COOKIE_JARS = ThreadLocal.withInitial(() -> new CookieManager().getCookieStore());
    private static final SessionCookieManager INSTANCE = new SessionCookieManager();

    public SessionCookieManager() {
        this(null);
    }

    public static SessionCookieManager getInstance() {
        return INSTANCE;
    }

    public void clear() {
        COOKIE_JARS.remove();
    }

    public SessionCookieManager(CookiePolicy cookiePolicy) {
        this.policyCallback = cookiePolicy == null ? CookiePolicy.ACCEPT_ALL : cookiePolicy;
    }

    @Override
    public Map<String, List<String>> get(URI uri, Map<String, List<String>> requestHeaders) throws IOException {
        if (uri == null || requestHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        HashMap<String, List<String>> cookieMap = new HashMap<String, List<String>>();
        if (this.getCookieStore() == null) {
            return Collections.unmodifiableMap(cookieMap);
        }
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        for (HttpCookie cookie : this.getCookieStore().get(uri)) {
            if (!this.pathMatches(uri.getPath(), cookie.getPath())) continue;
            cookies.add(cookie);
        }
        List<String> cookieHeader = this.sortByPath(cookies);
        cookieMap.put("Cookie", cookieHeader);
        return Collections.unmodifiableMap(cookieMap);
    }

    @Override
    public void put(URI uri, Map<String, List<String>> responseHeaders) throws IOException {
        if (uri == null || responseHeaders == null) {
            throw new IllegalArgumentException("Argument is null");
        }
        if (this.getCookieStore() == null) {
            return;
        }
        for (Map.Entry<String, List<String>> entrySetHeader : responseHeaders.entrySet()) {
            if (!"Set-Cookie2".equalsIgnoreCase(entrySetHeader.getKey()) && !"Set-Cookie".equalsIgnoreCase(entrySetHeader.getKey())) continue;
            this.putAcceptedCookie(uri, entrySetHeader);
        }
    }

    private void putAcceptedCookie(URI uri, Map.Entry<String, List<String>> entrySetHeader) {
        for (String headerValue : entrySetHeader.getValue()) {
            try {
                List<HttpCookie> cookies = HttpCookie.parse(headerValue);
                for (HttpCookie cookie : cookies) {
                    if (!this.shouldAcceptInternal(uri, cookie)) continue;
                    this.getCookieStore().add(uri, cookie);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
    }

    private boolean shouldAcceptInternal(URI uri, HttpCookie cookie) {
        try {
            return this.policyCallback.shouldAccept(uri, cookie);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean pathMatches(String pathUri, String pathToMatchWith) {
        if (Objects.equals(pathUri, pathToMatchWith)) {
            return true;
        }
        if (pathUri == null || pathToMatchWith == null) {
            return false;
        }
        return pathUri.startsWith(pathToMatchWith);
    }

    private List<String> sortByPath(List<HttpCookie> cookies) {
        Collections.sort(cookies, new CookiePathComparator());
        ArrayList<String> cookieHeader = new ArrayList<String>();
        for (HttpCookie cookie : cookies) {
            if (cookies.indexOf(cookie) == 0 && cookie.getVersion() > 0) {
                cookieHeader.add("$Version=\"1\"");
            }
            cookieHeader.add(cookie.toString());
        }
        return cookieHeader;
    }

    public void setCookiePolicy(CookiePolicy cookiePolicy) {
        if (cookiePolicy != null) {
            this.policyCallback = cookiePolicy;
        }
    }

    public CookieStore getCookieStore() {
        return COOKIE_JARS.get();
    }

    private class CookiePathComparator
    implements Comparator<HttpCookie> {
        private CookiePathComparator() {
        }

        @Override
        public int compare(HttpCookie c1, HttpCookie c2) {
            if (c1 == c2) {
                return 0;
            }
            if (c1 == null) {
                return -1;
            }
            if (c2 == null) {
                return 1;
            }
            if (!c1.getName().equals(c2.getName())) {
                return 0;
            }
            if (c1.getPath().startsWith(c2.getPath())) {
                return -1;
            }
            if (c2.getPath().startsWith(c1.getPath())) {
                return 1;
            }
            return 0;
        }
    }
}

