/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util.bruter;

import com.jsql.util.LogLevel;
import com.jsql.util.bruter.Bruter;
import com.jsql.util.bruter.Crc16Helper;
import com.jsql.util.bruter.Crc64Helper;
import com.jsql.util.bruter.HashUtil;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HashBruter
extends Bruter {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String hash;
    private String generatedHash;
    private String password;
    private String type;

    public void tryBruteForce() {
        this.starttime = System.nanoTime();
        for (int size = this.minLength; size <= this.maxLength && !this.found && !this.done; ++size) {
            while (this.paused) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            try {
                this.generateAllPossibleCombinations("", size);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        this.done = true;
    }

    private void generateAllPossibleCombinations(String baseString, int length) throws NoSuchAlgorithmException, InterruptedException {
        while (this.paused) {
            Thread.sleep(500L);
        }
        if (!this.found || !this.done) {
            if (baseString.length() == length) {
                switch (this.type.toLowerCase()) {
                    case "adler32": {
                        this.generatedHash = HashUtil.toAdler32(baseString);
                        break;
                    }
                    case "crc16": {
                        this.generatedHash = Crc16Helper.generateCRC16(baseString);
                        break;
                    }
                    case "crc32": {
                        this.generatedHash = HashUtil.toCrc32(baseString);
                        break;
                    }
                    case "crc64": {
                        this.generatedHash = Crc64Helper.generateCRC64(baseString.getBytes());
                        break;
                    }
                    case "mysql": {
                        this.generatedHash = HashUtil.toMySql(baseString);
                        break;
                    }
                    case "md4": {
                        this.generatedHash = HashUtil.toMd4(baseString);
                        break;
                    }
                    default: {
                        this.generatedHash = HashUtil.toHash(this.type, baseString);
                    }
                }
                this.password = baseString;
                if (this.hash.equals(this.generatedHash)) {
                    this.found = true;
                    this.done = true;
                }
                ++this.count;
            } else if (baseString.length() < length) {
                for (String element : this.characters) {
                    this.generateAllPossibleCombinations(baseString + element, length);
                }
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setType(String digestType) {
        this.type = digestType;
    }

    public String getGeneratedHash() {
        return this.generatedHash;
    }
}

