/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy.blind;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBoolean;
import com.jsql.model.injection.strategy.blind.CallableBlind;
import com.jsql.model.injection.strategy.blind.patch.Diff;
import com.jsql.util.LogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InjectionBlind
extends AbstractInjectionBoolean<CallableBlind> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String blankTrueMark;
    private List<Diff> constantFalseMark = new ArrayList<Diff>();

    public InjectionBlind(InjectionModel injectionModel, AbstractInjectionBoolean.BooleanMode blindMode) {
        super(injectionModel, blindMode);
        if (this.falseTest.isEmpty() || this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.blankTrueMark = this.callUrl("", "blind#ref");
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindTagFalse");
        ArrayList<CallableBlind> listCallableTagFalse = new ArrayList<CallableBlind>();
        for (String urlTest : this.falseTest) {
            listCallableTagFalse.add(new CallableBlind(urlTest, injectionModel, this, blindMode, "blind#false"));
        }
        try {
            List listTagFalse = taskExecutor.invokeAll(listCallableTagFalse);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            this.constantFalseMark = ((CallableBlind)listTagFalse.get(0).get()).getOpcodes();
            for (Future falseMark : listTagFalse) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                this.constantFalseMark.retainAll(((CallableBlind)falseMark.get()).getOpcodes());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (this.injectionModel.isStoppedByUser()) {
            return;
        }
        this.initializeTrueMarks(injectionModel, blindMode);
    }

    private void initializeTrueMarks(InjectionModel injectionModel, AbstractInjectionBoolean.BooleanMode blindMode) {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableGetBlindTagTrue");
        ArrayList<CallableBlind> listCallableTagTrue = new ArrayList<CallableBlind>();
        for (String urlTest : this.trueTest) {
            listCallableTagTrue.add(new CallableBlind(urlTest, injectionModel, this, blindMode, "blind#true"));
        }
        try {
            List listTagTrue = taskExecutor.invokeAll(listCallableTagTrue);
            taskExecutor.shutdown();
            if (!taskExecutor.awaitTermination(15L, TimeUnit.SECONDS)) {
                taskExecutor.shutdownNow();
            }
            for (Future trueTag : listTagTrue) {
                if (this.injectionModel.isStoppedByUser()) {
                    return;
                }
                this.constantFalseMark.removeAll(((CallableBlind)trueTag.get()).getOpcodes());
            }
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public CallableBlind getCallableSizeTest(String string, int indexCharacter) {
        return new CallableBlind(string, indexCharacter, this.injectionModel, this, this.booleanMode, "blind#size");
    }

    @Override
    public CallableBlind getCallableBitTest(String string, int indexCharacter, int bit) {
        return new CallableBlind(string, indexCharacter, bit, this.injectionModel, this, this.booleanMode, "blind#bit");
    }

    @Override
    public boolean isInjectable() throws StoppedByUserSlidingException {
        if (this.injectionModel.isStoppedByUser()) {
            throw new StoppedByUserSlidingException();
        }
        CallableBlind blindTest = new CallableBlind(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestBooleanInitialization(), this.injectionModel, this, this.booleanMode, "blind#confirm");
        try {
            blindTest.call();
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        return blindTest.isTrue() && !this.constantFalseMark.isEmpty();
    }

    @Override
    public String getInfoMessage() {
        return "Blind strategy: a request is true if the diff between a correct page (e.g existing id) and current page is not as the following: " + this.constantFalseMark;
    }

    public String getBlankTrueMark() {
        return this.blankTrueMark;
    }

    public List<Diff> getConstantFalseMark() {
        return this.constantFalseMark;
    }
}

