/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.vendor.model.VendorYaml;
import com.jsql.model.injection.vendor.model.yaml.Configuration;
import com.jsql.model.injection.vendor.model.yaml.Method;
import com.jsql.model.injection.vendor.model.yaml.Strategy;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class StrategyInjectionError
extends AbstractStrategy {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String[] tabCapacityMethod;
    private int indexErrorStrategy = 0;

    public StrategyInjectionError(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public void checkApplicability() {
        this.isApplicable = false;
        Strategy strategyYaml = this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy();
        if (strategyYaml.getError().getMethod().isEmpty()) {
            LOGGER.log(LogLevel.CONSOLE_DEFAULT, "No Error strategy for {}", (Object)this.injectionModel.getMediatorVendor().getVendor());
            return;
        }
        Configuration configurationYaml = strategyYaml.getConfiguration();
        LOGGER.log(LogLevel.CONSOLE_DEFAULT, "{} Error...", () -> I18nUtil.valueByKey("LOG_CHECKING_STRATEGY"));
        this.tabCapacityMethod = new String[strategyYaml.getError().getMethod().size()];
        int indexErrorMethod = 0;
        int errorCapacity = 0;
        for (Method errorMethod : strategyYaml.getError().getMethod()) {
            boolean methodIsApplicable = this.isApplicable(configurationYaml, errorMethod);
            if (methodIsApplicable) {
                Matcher regexSearch = this.getPerformance(configurationYaml, errorMethod);
                if (regexSearch.find()) {
                    errorCapacity = this.getCapacity(indexErrorMethod, errorCapacity, errorMethod, regexSearch);
                } else {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> I18nUtil.valueByKey("LOG_VULNERABLE");
                    supplierArray[1] = errorMethod::getName;
                    LOGGER.log(LogLevel.CONSOLE_ERROR, "{} {} but injectable size is incorrect", supplierArray);
                    methodIsApplicable = false;
                }
            }
            if (methodIsApplicable) {
                this.allow(indexErrorMethod);
            } else {
                this.unallow(indexErrorMethod);
            }
            ++indexErrorMethod;
        }
    }

    private boolean isApplicable(Configuration configurationYaml, Method errorMethod) {
        boolean methodIsApplicable = false;
        String performanceSourcePage = this.injectionModel.injectWithoutIndex(" " + VendorYaml.replaceTags(errorMethod.getQuery().replace("${window}", configurationYaml.getSlidingWindow()).replace("${injection}", configurationYaml.getFailsafe().replace("${indice}", "0")).replace("${window.char}", "1").replace("${capacity}", Integer.toString(errorMethod.getCapacity()))), "error#confirm");
        if (performanceSourcePage.matches(VendorYaml.replaceTags("(?s).*133707331.*"))) {
            methodIsApplicable = true;
            this.isApplicable = true;
        }
        return methodIsApplicable;
    }

    private Matcher getPerformance(Configuration configurationYaml, Method errorMethod) {
        String performanceErrorSourcePage = this.injectionModel.injectWithoutIndex(" " + VendorYaml.replaceTags(errorMethod.getQuery().replace("${window}", configurationYaml.getSlidingWindow()).replace("${injection}", configurationYaml.getCalibrator()).replace("${window.char}", "1").replace("${capacity}", Integer.toString(errorMethod.getCapacity()))), "error#size");
        return Pattern.compile("(?s)SqLi(#+)").matcher(performanceErrorSourcePage);
    }

    private int getCapacity(int indexErrorMethod, int errorCapacityDefault, Method errorMethod, Matcher regexSearch) {
        int errorCapacityImproved = errorCapacityDefault;
        regexSearch.reset();
        while (regexSearch.find()) {
            if (errorCapacityImproved < regexSearch.group(1).length()) {
                this.indexErrorStrategy = indexErrorMethod;
            }
            errorCapacityImproved = regexSearch.group(1).length();
            this.tabCapacityMethod[indexErrorMethod] = Integer.toString(errorCapacityImproved);
        }
        int logErrorCapacityImproved = errorCapacityImproved;
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = () -> I18nUtil.valueByKey("LOG_VULNERABLE");
        supplierArray[1] = errorMethod::getName;
        supplierArray[2] = () -> Integer.toString(logErrorCapacityImproved);
        LOGGER.log(LogLevel.CONSOLE_SUCCESS, "{} [Error {}] using [{}] characters", supplierArray);
        return errorCapacityImproved;
    }

    @Override
    public void allow(int ... indexError) {
        this.markVulnerability(Interaction.MARK_ERROR_VULNERABLE, indexError[0]);
    }

    @Override
    public void unallow(int ... indexError) {
        this.markVulnerability(Interaction.MARK_ERROR_INVULNERABLE, indexError[0]);
    }

    @Override
    public String inject(String sqlQuery, String startPosition, AbstractSuspendable stoppable, String metadataInjectionProcess) throws StoppedByUserSlidingException {
        return this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlError(sqlQuery, startPosition), metadataInjectionProcess);
    }

    @Override
    public void activateStrategy() {
        LOGGER.log(LogLevel.CONSOLE_INFORM, "{} [{} {}]", () -> I18nUtil.valueByKey("LOG_USING_STRATEGY"), this::getName, () -> this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getStrategy().getError().getMethod().get(this.indexErrorStrategy).getName());
        this.injectionModel.getMediatorStrategy().setStrategy(this.injectionModel.getMediatorStrategy().getError());
        Request request = new Request();
        request.setMessage(Interaction.MARK_ERROR_STRATEGY);
        this.injectionModel.sendToViews(request);
    }

    @Override
    public String getPerformanceLength() {
        return this.tabCapacityMethod[this.indexErrorStrategy];
    }

    @Override
    public String getName() {
        return "Error";
    }

    public Integer getIndexErrorStrategy() {
        return this.indexErrorStrategy;
    }

    public void setIndexErrorStrategy(int indexErrorStrategy) {
        this.indexErrorStrategy = indexErrorStrategy;
    }
}

