/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.injection.strategy;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.injection.strategy.AbstractStrategy;
import com.jsql.model.injection.strategy.StrategyInjectionBlind;
import com.jsql.model.injection.strategy.StrategyInjectionError;
import com.jsql.model.injection.strategy.StrategyInjectionNormal;
import com.jsql.model.injection.strategy.StrategyInjectionTime;
import com.jsql.model.suspendable.SuspendableGetCharInsertion;
import com.jsql.util.StringUtil;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;

public class MediatorStrategy {
    private AbstractStrategy time;
    private AbstractStrategy blind;
    private StrategyInjectionError error;
    private AbstractStrategy normal;
    private List<AbstractStrategy> strategies;
    private AbstractStrategy strategy;
    private InjectionModel injectionModel;

    public MediatorStrategy(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        this.time = new StrategyInjectionTime(this.injectionModel);
        this.blind = new StrategyInjectionBlind(this.injectionModel);
        this.error = new StrategyInjectionError(this.injectionModel);
        this.normal = new StrategyInjectionNormal(this.injectionModel);
        this.strategies = Arrays.asList(this.time, this.blind, this.error, this.normal);
    }

    public String getMeta() {
        String strategyName = this.strategy == null ? "" : this.strategy.toString().toLowerCase();
        String strategyMode = "default";
        if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isDiosStrategy()) {
            strategyMode = "dios";
        } else if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isZipStrategy()) {
            strategyMode = "zip";
        }
        return String.format("%s#%s", strategyName, strategyMode);
    }

    public String buildURL(String urlBase, boolean isUsingIndex, String sqlTrail) {
        String result = urlBase;
        if (urlBase.contains("*")) {
            result = !isUsingIndex ? urlBase.replace("*", this.extracted(sqlTrail)) : urlBase.replace("*", this.extracted(this.injectionModel.getIndexesInUrl().replaceAll("1337" + this.normal.getVisibleIndex() + "7331", Matcher.quoteReplacement(sqlTrail))));
        }
        return result;
    }

    private String extracted(String sqlTrail) {
        return StringUtil.clean(sqlTrail).replace("\"", "%22").replace("'", "%27").replace("(", "%28").replace(")", "%29").replace("{", "%7B").replace("[", "%5B").replace("|", "%7C").replace("`", "%60").replace("]", "%5D").replace("}", "%7D").replace(">", "%3E").replace("<", "%3C").replace("?", "%3F").replace("_", "%5F").replace("\\", "%5C").replace(",", "%2C").replace(" ", "%20").replace("+", "%20") + this.injectionModel.getMediatorVendor().getVendor().instance().endingComment().replace("+", "%20");
    }

    public boolean testStrategies(AbstractMap.SimpleEntry<String, String> parameterToInject) throws JSqlException {
        String parameterOriginalValue = null;
        this.injectionModel.getMediatorVendor().setVendor(this.injectionModel.getMediatorVendor().fingerprintVendor());
        if (parameterToInject != null) {
            parameterOriginalValue = parameterToInject.getValue();
            String characterInsertionByUser = this.injectionModel.getMediatorUtils().getParameterUtil().initializeStar(parameterToInject);
            String characterInsertion = new SuspendableGetCharInsertion(this.injectionModel).run(characterInsertionByUser);
            if (characterInsertion.contains("*")) {
                parameterToInject.setValue(characterInsertion);
            } else {
                parameterToInject.setValue(characterInsertion + "+*");
            }
        }
        this.time.checkApplicability();
        this.blind.checkApplicability();
        this.error.checkApplicability();
        this.normal.checkApplicability();
        if (this.normal.isApplicable()) {
            this.normal.activateStrategy();
        } else if (this.error.isApplicable()) {
            this.error.activateStrategy();
        } else if (this.blind.isApplicable()) {
            this.blind.activateStrategy();
        } else if (this.time.isApplicable()) {
            this.time.activateStrategy();
        } else {
            if (parameterOriginalValue != null) {
                parameterToInject.setValue(parameterOriginalValue.replace("*", ""));
            }
            throw new InjectionFailureException("No injection found");
        }
        return true;
    }

    public AbstractStrategy getNormal() {
        return this.normal;
    }

    public StrategyInjectionError getError() {
        return this.error;
    }

    public AbstractStrategy getBlind() {
        return this.blind;
    }

    public AbstractStrategy getTime() {
        return this.time;
    }

    public List<AbstractStrategy> getStrategies() {
        return this.strategies;
    }

    public AbstractStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(AbstractStrategy strategy) {
        this.strategy = strategy;
    }
}

