/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.bean.database;

import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.bean.database.Database;
import com.jsql.util.LogLevel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Table
extends AbstractElementDatabase {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private Database parentDatabase;
    private String rowCount;

    public Table(String tableName, String rowCount, Database parentDatabase) {
        this.elementValue = tableName;
        this.rowCount = rowCount;
        this.parentDatabase = parentDatabase;
    }

    @Override
    public AbstractElementDatabase getParent() {
        return this.parentDatabase;
    }

    @Override
    public int getChildCount() {
        return Integer.parseInt(this.rowCount);
    }

    @Override
    public String getLabelCount() {
        String nbRow = "information_schema".equals(this.parentDatabase.toString()) ? "?" : this.rowCount;
        String sPlural = "";
        try {
            if (Integer.parseInt(this.rowCount) > 1) {
                sPlural = "s";
            }
        }
        catch (NumberFormatException e) {
            this.rowCount = "0";
            nbRow = "0";
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Incorrect number of rows.");
        }
        return String.format("%s (%s row%s)", this.elementValue, nbRow, sPlural);
    }
}

