/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.database.AbstractElementDatabase;
import com.jsql.model.bean.database.Column;
import com.jsql.model.bean.database.Database;
import com.jsql.model.bean.database.Table;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.AbstractSlidingException;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.JSqlException;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataAccess {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String LEAD_HEX = "0x53714c69";
    public static final String TRAIL_SQL = "%01%03%03%07";
    public static final String TRAIL_HEX = "0x01030307";
    public static final String TRAIL_RGX = "\\x01\\x03\\x03\\x07";
    public static final String SEPARATOR_FIELD_HEX = "0x7f";
    public static final String SEPARATOR_FIELD_SQL = "%7f";
    public static final String SEPARATOR_CELL_RGX = "\\x06";
    public static final String SEPARATOR_CELL_SQL = "%06";
    public static final String SEPARATOR_CELL_HEX = "0x06";
    public static final String SEPARATOR_QTE_SQL = "%05";
    public static final String SEPARATOR_QTE_RGX = "\\x05";
    public static final String SEPARATOR_QTE_HEX = "0x05";
    public static final String ENCLOSE_VALUE_RGX = "\\x04";
    public static final String ENCLOSE_VALUE_HEX = "0x04";
    public static final String ENCLOSE_VALUE_SQL = "%04";
    public static final String CALIBRATOR_SQL = "%23";
    public static final String CALIBRATOR_HEX = "0x23";
    public static final String LEAD = "SqLi";
    public static final String SHELL_LEAD = "${shell.lead}";
    public static final String TRAIL = "iLQS";
    public static final String SHELL_TRAIL = "${shell.trail}";
    public static final String MODE = "(?si)";
    public static final String CELL_TABLE = "([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)\\x05([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)(\\x08)?";
    private InjectionModel injectionModel;

    public DataAccess(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public void getDatabaseInfos() throws JSqlException {
        LOGGER.log(LogLevel.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("LOG_FETCHING_INFORMATIONS"));
        String[] sourcePage = new String[]{""};
        String resultToParse = "";
        try {
            resultToParse = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlInfos(), sourcePage, false, 0, null, "metadata");
        }
        catch (AbstractSlidingException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage());
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isEmpty(resultToParse)) {
            this.injectionModel.sendResponseFromSite("Incorrect metadata", sourcePage[0].trim());
        }
        try {
            String versionDatabase = resultToParse.split(ENCLOSE_VALUE_RGX)[0].replaceAll("\\s+", " ");
            String nameDatabase = resultToParse.split(ENCLOSE_VALUE_RGX)[1];
            String username = resultToParse.split(ENCLOSE_VALUE_RGX)[2];
            String infos = String.format("Database [%s] on %s [%s] for user [%s]", nameDatabase, this.injectionModel.getMediatorVendor().getVendor(), versionDatabase, username);
            LOGGER.log(LogLevel.CONSOLE_SUCCESS, infos);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, String.format("%s: %s", I18nUtil.valueByKey("LOG_DB_METADATA_INCORRECT"), resultToParse), (Throwable)e);
            LOGGER.log(LogLevel.CONSOLE_INFORM, I18nUtil.valueByKey("LOG_DB_METADATA_WARN"));
        }
    }

    public List<Database> listDatabases() throws JSqlException {
        LOGGER.log(LogLevel.CONSOLE_DEFAULT, () -> I18nUtil.valueByKey("LOG_FETCHING_DATABASES"));
        ArrayList<Database> databases = new ArrayList<Database>();
        String resultToParse = "";
        try {
            String[] sourcePage = new String[]{""};
            resultToParse = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlDatabases(), sourcePage, true, 0, null, "databases");
        }
        catch (AbstractSlidingException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage());
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage(), (Throwable)e);
        }
        Matcher regexSearch = Pattern.compile("(?si)\\x04([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)\\x05([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)(\\x08)?\\x04").matcher(resultToParse);
        if (!regexSearch.find()) {
            throw new InjectionFailureException("No match while injecting databases");
        }
        regexSearch.reset();
        while (regexSearch.find()) {
            String databaseName = regexSearch.group(1);
            String tableCount = regexSearch.group(2);
            Database newDatabase = new Database(databaseName, tableCount);
            databases.add(newDatabase);
        }
        Request request = new Request();
        request.setMessage(Interaction.ADD_DATABASES);
        request.setParameters(databases);
        this.injectionModel.sendToViews(request);
        return databases;
    }

    public List<Table> listTables(Database database) throws JSqlException {
        this.injectionModel.setIsStoppedByUser(false);
        Request requestStartProgress = new Request();
        requestStartProgress.setMessage(Interaction.START_PROGRESS);
        requestStartProgress.setParameters(database);
        this.injectionModel.sendToViews(requestStartProgress);
        String tableCount = Integer.toString(database.getChildCount());
        String resultToParse = "";
        try {
            String[] pageSource = new String[]{""};
            resultToParse = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlTables(database), pageSource, true, Integer.parseInt(tableCount), database, "tables");
        }
        catch (AbstractSlidingException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage());
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage(), (Throwable)e);
        }
        Matcher regexSearch = Pattern.compile("(?si)\\x04([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)\\x05([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)(\\x08)?\\x04").matcher(resultToParse);
        Request requestEndProgress = new Request();
        requestEndProgress.setMessage(Interaction.END_PROGRESS);
        requestEndProgress.setParameters(database);
        this.injectionModel.sendToViews(requestEndProgress);
        if (!regexSearch.find()) {
            throw new InjectionFailureException("No match while injecting tables");
        }
        regexSearch.reset();
        ArrayList<Table> tables = new ArrayList<Table>();
        while (regexSearch.find()) {
            String tableName = regexSearch.group(1);
            String rowCount = regexSearch.group(2);
            Table newTable = new Table(tableName, rowCount, database);
            tables.add(newTable);
        }
        Request requestAddTables = new Request();
        requestAddTables.setMessage(Interaction.ADD_TABLES);
        requestAddTables.setParameters(tables);
        this.injectionModel.sendToViews(requestAddTables);
        return tables;
    }

    public List<Column> listColumns(Table table) throws JSqlException {
        ArrayList<Column> columns = new ArrayList<Column>();
        Request requestStartProgress = new Request();
        requestStartProgress.setMessage(Interaction.START_INDETERMINATE_PROGRESS);
        requestStartProgress.setParameters(table);
        this.injectionModel.sendToViews(requestStartProgress);
        String resultToParse = "";
        try {
            String[] pageSource = new String[]{""};
            resultToParse = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlColumns(table), pageSource, true, 0, table, "columns");
        }
        catch (AbstractSlidingException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage());
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage(), (Throwable)e);
        }
        if (this.injectionModel.getMediatorVendor().isSqlite()) {
            resultToParse = this.injectionModel.getMediatorVendor().getSqlite().transformSqlite(resultToParse);
        }
        Matcher regexSearch = Pattern.compile("(?si)\\x04([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)\\x05([^\\x01-\\x09\\x0B-\\x0C\\x0E-\\x1F]*)(\\x08)?\\x04").matcher(resultToParse);
        Request requestEndProgress = new Request();
        requestEndProgress.setMessage(Interaction.END_INDETERMINATE_PROGRESS);
        requestEndProgress.setParameters(table);
        this.injectionModel.sendToViews(requestEndProgress);
        if (!regexSearch.find()) {
            throw new InjectionFailureException("No match while injecting columns");
        }
        regexSearch.reset();
        while (regexSearch.find()) {
            String nameColumn = regexSearch.group(1);
            Column column = new Column(nameColumn, table);
            columns.add(column);
        }
        Request requestAddColumns = new Request();
        requestAddColumns.setMessage(Interaction.ADD_COLUMNS);
        requestAddColumns.setParameters(columns);
        this.injectionModel.sendToViews(requestAddColumns);
        return columns;
    }

    public String[][] listValues(List<Column> columns) throws JSqlException {
        Database database = (Database)columns.get(0).getParent().getParent();
        Table table = (Table)columns.get(0).getParent();
        int rowCount = columns.get(0).getParent().getChildCount();
        Request request = new Request();
        request.setMessage(Interaction.START_PROGRESS);
        request.setParameters(table);
        this.injectionModel.sendToViews(request);
        ArrayList<String> columnsName = new ArrayList<String>();
        for (AbstractElementDatabase abstractElementDatabase : columns) {
            columnsName.add(abstractElementDatabase.toString());
        }
        String[] arrayColumns = columnsName.toArray(new String[columnsName.size()]);
        List<List<String>> list = this.getRows(database, table, rowCount, arrayColumns);
        columnsName.add(0, "");
        columnsName.add(0, "");
        String[][] tableDatas = this.build2D(columnsName, list);
        arrayColumns = columnsName.toArray(new String[columnsName.size()]);
        Object[] objectData = new Object[]{arrayColumns, tableDatas, table};
        Request requestCreateValuesTab = new Request();
        requestCreateValuesTab.setMessage(Interaction.CREATE_VALUES_TAB);
        requestCreateValuesTab.setParameters(objectData);
        this.injectionModel.sendToViews(requestCreateValuesTab);
        Request requestEndProgress = new Request();
        requestEndProgress.setMessage(Interaction.END_PROGRESS);
        requestEndProgress.setParameters(table);
        this.injectionModel.sendToViews(requestEndProgress);
        return tableDatas;
    }

    private List<List<String>> getRows(Database database, Table table, int rowCount, String[] columns) throws InjectionFailureException {
        String resultToParse = "";
        try {
            String[] pageSource = new String[]{""};
            resultToParse = new SuspendableGetRows(this.injectionModel).run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlRows(columns, database, table), pageSource, true, rowCount, table, "rows");
        }
        catch (AbstractSlidingException e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage(), (Throwable)e);
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
        }
        catch (Exception e) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, e.getMessage(), (Throwable)e);
        }
        return SuspendableGetRows.parse(resultToParse);
    }

    private String[][] build2D(List<String> columnsName, List<List<String>> listValues) {
        String[][] tableDatas = new String[listValues.size()][columnsName.size()];
        for (int indexRow = 0; indexRow < listValues.size(); ++indexRow) {
            boolean isIncomplete = false;
            for (int indexColumn = 0; indexColumn < columnsName.size(); ++indexColumn) {
                try {
                    tableDatas[indexRow][indexColumn] = listValues.get(indexRow).get(indexColumn);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    isIncomplete = true;
                    LOGGER.log(LogLevel.CONSOLE_DEFAULT, I18nUtil.valueByKey("LOG_LIST_VALUES_INCOMPLETE"));
                    LOGGER.log(LogLevel.IGNORE, e);
                }
            }
            if (!isIncomplete) continue;
            int logIndexRow = indexRow;
            LOGGER.log(LogLevel.CONSOLE_ERROR, "{}{}: ", () -> I18nUtil.valueByKey("LOG_LIST_VALUES_TOO_LONG"), () -> logIndexRow + 1);
            LOGGER.log(LogLevel.CONSOLE_ERROR, () -> String.join((CharSequence)", ", ((List)listValues.get(logIndexRow)).toArray(new String[((List)listValues.get(logIndexRow)).size()])));
        }
        return tableDatas;
    }
}

