/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevel;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallableHttpHead
implements Callable<CallableHttpHead> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String urlAdminPage;
    private String responseCodeHttp = "";
    private InjectionModel injectionModel;
    private String metadataInjectionProcess;

    public CallableHttpHead(String urlAdminPage, InjectionModel injectionModel, String metadataInjectionProcess) {
        this.urlAdminPage = urlAdminPage;
        this.injectionModel = injectionModel;
        this.metadataInjectionProcess = metadataInjectionProcess;
    }

    @Override
    public CallableHttpHead call() throws Exception {
        if (this.injectionModel.getResourceAccess().isSearchAdminStopped()) {
            return this;
        }
        boolean isUrlIncorrect = false;
        URL targetUrl = null;
        try {
            targetUrl = new URL(this.urlAdminPage);
        }
        catch (MalformedURLException e) {
            isUrlIncorrect = true;
        }
        if (isUrlIncorrect || StringUtils.isEmpty(targetUrl.getHost())) {
            LOGGER.log(LogLevel.CONSOLE_ERROR, "Incorrect URL: {}", (Object)this.urlAdminPage);
            return this;
        }
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.urlAdminPage)).method("HEAD", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(4L)).build();
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(4L)).build();
        HttpResponse<Void> response = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
        Map<String, String> mapHeaders = ConnectionUtil.getHeadersMap(response.headers());
        this.responseCodeHttp = "" + response.statusCode();
        mapHeaders.put(":status", this.responseCodeHttp);
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        msgHeader.put(Header.URL, this.urlAdminPage);
        msgHeader.put(Header.POST, "");
        msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
        msgHeader.put(Header.RESPONSE, ConnectionUtil.getHeadersMap(response));
        msgHeader.put(Header.METADATA_PROCESS, this.metadataInjectionProcess);
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
        return this;
    }

    public boolean isHttpResponseOk() {
        return this.responseCodeHttp.matches("[23]\\d\\d");
    }

    public String getUrl() {
        return this.urlAdminPage;
    }
}

