/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.accessible;

import com.jsql.model.InjectionModel;
import com.jsql.model.exception.InjectionFailureException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.suspendable.SuspendableGetRows;
import com.jsql.util.LogLevel;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CallableFile
implements Callable<CallableFile> {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private String pathFile;
    private String sourceFile = "";
    private SuspendableGetRows suspendableReadFile;
    private InjectionModel injectionModel;

    public CallableFile(String pathFile, InjectionModel injectionModel) {
        this.pathFile = pathFile;
        this.injectionModel = injectionModel;
        this.suspendableReadFile = new SuspendableGetRows(injectionModel);
    }

    @Override
    public CallableFile call() throws Exception {
        String[] sourcePage = new String[]{""};
        String resultToParse = "";
        try {
            resultToParse = this.suspendableReadFile.run(this.injectionModel.getMediatorVendor().getVendor().instance().sqlFileRead(this.pathFile), sourcePage, false, 1, null, "file");
        }
        catch (InjectionFailureException e) {
            LOGGER.log(LogLevel.IGNORE, e);
        }
        catch (StoppedByUserSlidingException e) {
            if (StringUtils.isNotEmpty(e.getSlidingWindowAllRows())) {
                resultToParse = e.getSlidingWindowAllRows();
            } else if (StringUtils.isNotEmpty(e.getSlidingWindowCurrentRows())) {
                resultToParse = e.getSlidingWindowCurrentRows();
            }
            LOGGER.log(LogLevel.IGNORE, e);
        }
        this.sourceFile = resultToParse;
        return this;
    }

    public String getPathFile() {
        return this.pathFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public SuspendableGetRows getSuspendableReadFile() {
        return this.suspendableReadFile;
    }
}

