/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AndFileFilter
implements FileFilter {
    private List<FileFilter> fileFilters;

    public AndFileFilter() {
        this(new ArrayList<FileFilter>());
    }

    public AndFileFilter(FileFilter ... fileFilters) {
        this(Arrays.asList(fileFilters));
    }

    public AndFileFilter(List<FileFilter> fileFilters) {
        this.fileFilters = new ArrayList<FileFilter>(fileFilters);
    }

    public AndFileFilter addFileFilter(FileFilter fileFilter) {
        this.fileFilters.add(fileFilter);
        return this;
    }

    public List<FileFilter> getFileFilters() {
        return Collections.unmodifiableList(this.fileFilters);
    }

    public boolean removeFileFilter(FileFilter fileFilter) {
        return this.fileFilters.remove(fileFilter);
    }

    public void setFileFilters(List<FileFilter> fileFilters) {
        this.fileFilters = new ArrayList<FileFilter>(fileFilters);
    }

    @Override
    public boolean accept(File file) {
        if (this.fileFilters.size() == 0) {
            return false;
        }
        for (FileFilter fileFilter : this.fileFilters) {
            if (fileFilter.accept(file)) continue;
            return false;
        }
        return true;
    }
}

