/*
 * Decompiled with CFR 0.152.
 */
package ro.fortsoft.pf4j;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.fortsoft.pf4j.PluginStatusProvider;
import ro.fortsoft.pf4j.util.FileUtils;

public class DefaultPluginStatusProvider
implements PluginStatusProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginStatusProvider.class);
    private final Path pluginsRoot;
    private List<String> enabledPlugins;
    private List<String> disabledPlugins;

    public DefaultPluginStatusProvider(Path pluginsRoot) {
        this.pluginsRoot = pluginsRoot;
        this.initialize();
    }

    private void initialize() {
        try {
            this.enabledPlugins = FileUtils.readLines(this.pluginsRoot.resolve("enabled.txt").toFile(), true);
            log.info("Enabled plugins: {}", (Object)this.enabledPlugins);
            this.disabledPlugins = FileUtils.readLines(this.pluginsRoot.resolve("disabled.txt").toFile(), true);
            log.info("Disabled plugins: {}", (Object)this.disabledPlugins);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
    }

    @Override
    public boolean isPluginDisabled(String pluginId) {
        if (this.disabledPlugins.contains(pluginId)) {
            return true;
        }
        return !this.enabledPlugins.isEmpty() && !this.enabledPlugins.contains(pluginId);
    }

    @Override
    public boolean disablePlugin(String pluginId) {
        if (this.disabledPlugins.add(pluginId)) {
            try {
                FileUtils.writeLines(this.disabledPlugins, this.pluginsRoot.resolve("disabled.txt").toFile());
            }
            catch (IOException e) {
                log.error("Failed to disable plugin {}", (Object)pluginId, (Object)e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean enablePlugin(String pluginId) {
        try {
            if (this.disabledPlugins.remove(pluginId)) {
                FileUtils.writeLines(this.disabledPlugins, this.pluginsRoot.resolve("disabled.txt").toFile());
            }
        }
        catch (IOException e) {
            log.error("Failed to enable plugin {}", (Object)pluginId, (Object)e);
            return false;
        }
        return true;
    }
}

