/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.properties;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.StatusUpdater;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.plugins.extensions.Notifier;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.EscapableDialog;
import ch.rakudave.jnetmap.view.components.TabPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MapProperties
extends EscapableDialog {
    public MapProperties(Frame owner, Map m) {
        super((Window)owner, Lang.getNoHTML("map.properties"));
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(400, 400));
        this.setMinimumSize(new Dimension(400, 300));
        JPanel topWrapper = new JPanel(new GridLayout(0, 2, 5, 5));
        topWrapper.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        SpinnerNumberModel updateInterval = new SpinnerNumberModel(m.getUpdateInterval(), 0.1, 60.0, 0.1);
        JSpinner updateSpinner = new JSpinner(updateInterval);
        topWrapper.add(new JLabel(Lang.get("map.updateinterval")));
        topWrapper.add(updateSpinner);
        topWrapper.add(new JLabel(Lang.get("map.background")));
        BackgroundChooser bc = new BackgroundChooser(this, m.getBackground());
        topWrapper.add(bc);
        JPanel listWrapper = new JPanel(new BorderLayout());
        listWrapper.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("map.notifiers")));
        JList<Notifier> listenerList = new JList<Notifier>(new Vector<Notifier>(m.getStatusListeners()));
        listenerList.setCellRenderer(new IconListRenderer(true));
        JPanel addWrapper = new JPanel(new BorderLayout());
        JComboBox<Notifier> addSelector = new JComboBox<Notifier>(new Vector<Notifier>(){
            {
                List<Notifier> notifiers = Controller.getPluginManager().getExtensions(Notifier.class);
                notifiers.sort(Comparator.comparing(Notifier::getName));
                for (Notifier notifier : notifiers) {
                    try {
                        this.add(notifier);
                    }
                    catch (Exception e) {
                        Logger.error("Unable to load plugin " + notifier, e);
                    }
                }
            }
        });
        addSelector.setRenderer(new IconListRenderer(false));
        JButton addListener = new JButton(Lang.get("action.add"), Icons.get("add"));
        addListener.setPreferredSize(new Dimension(100, 30));
        addListener.addActionListener(e -> {
            Notifier newListener = (Notifier)((Notifier)addSelector.getSelectedItem()).create();
            m.addStatusListener(newListener);
            newListener.showPropertiesWindow(owner, true);
            listenerList.setListData(new Vector<Notifier>(m.getStatusListeners()));
        });
        addWrapper.add(addSelector, "Center");
        addWrapper.add((Component)addListener, "East");
        JPanel listManipulators = new JPanel();
        listManipulators.setLayout(new BoxLayout(listManipulators, 3));
        JButton removeListener = new JButton(Lang.get("action.remove"), Icons.get("remove"));
        removeListener.setPreferredSize(new Dimension(100, 30));
        removeListener.addActionListener(e -> {
            if (listenerList.getSelectedIndex() == -1) {
                return;
            }
            m.removeStatusListener((Notifier)listenerList.getSelectedValue());
            listenerList.setListData(new Vector<Notifier>(m.getStatusListeners()));
        });
        JButton editListener = new JButton(Lang.get("action.edit"), Icons.get("edit"));
        editListener.setPreferredSize(new Dimension(100, 30));
        editListener.addActionListener(e -> {
            if (listenerList.getSelectedIndex() == -1) {
                return;
            }
            ((Notifier)listenerList.getSelectedValue()).showPropertiesWindow(owner, false);
            listenerList.setListData(new Vector<Notifier>(m.getStatusListeners()));
        });
        listManipulators.add(removeListener);
        listManipulators.add(editListener);
        listManipulators.add(Box.createVerticalGlue());
        listWrapper.add((Component)addWrapper, "North");
        listWrapper.add((Component)new JScrollPane(listenerList, 20, 31), "Center");
        listWrapper.add((Component)listManipulators, "East");
        JPanel bottomRow = new JPanel(new FlowLayout(2, 5, 5));
        MapProperties _this = this;
        JButton cancel = new JButton(Lang.get("action.cancel"), Icons.get("cancel"));
        cancel.addActionListener(e -> _this.dispose());
        JButton ok = new JButton(Lang.get("action.ok"), Icons.get("ok"));
        ok.setPreferredSize(cancel.getPreferredSize());
        ok.addActionListener(e -> {
            double newInterval = updateInterval.getNumber().doubleValue();
            if (m.getUpdateInterval() != newInterval) {
                Logger.debug("Update schedule changed from " + m.getUpdateInterval() + " to " + newInterval);
                m.setUpdateInterval(newInterval);
                StatusUpdater.updateTimeInterval(m);
            }
            m.setBackground(bc.getSelectedFile());
            m.setSaved(false);
            _this.dispose();
            if (TabPanel.getCurrentTab() != null) {
                TabPanel.getCurrentTab().repaint();
            }
        });
        bottomRow.add(cancel);
        bottomRow.add(ok);
        this.add((Component)topWrapper, "North");
        this.add((Component)listWrapper, "Center");
        this.add((Component)bottomRow, "South");
        this.pack();
        SwingHelper.centerTo(owner, this);
        this.setVisible(true);
    }

    private class IconListRenderer
    extends DefaultListCellRenderer {
        private boolean showName;

        public IconListRenderer(boolean showName) {
            this.showName = showName;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                return label;
            }
            Notifier l = (Notifier)value;
            label.setText(this.showName ? l.getPluginName() + ": " + l.getName() : l.getPluginName());
            label.setIcon(l.getIcon());
            return label;
        }
    }

    private class BackgroundChooser
    extends JPanel {
        private JTextField tf;

        public BackgroundChooser(Component owner, File file) {
            super(new BorderLayout());
            this.tf = new JTextField(file == null ? "" : file.getAbsolutePath());
            this.add((Component)this.tf, "Center");
            JButton b = new JButton("..");
            b.addActionListener(e -> {
                try {
                    this.tf.setText(SwingHelper.openDialog(owner, new FileNameExtensionFilter("jpg, png", "jpg", "jpeg", "png")).getAbsolutePath());
                }
                catch (Exception ex) {
                    Logger.debug("Invalid file received", ex);
                }
            });
            this.add((Component)b, "East");
        }

        public File getSelectedFile() {
            File f = new File(this.tf.getText());
            return f.canRead() ? f : null;
        }
    }
}

