/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.preferences;

import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Appender;
import ch.rakudave.jnetmap.util.logging.FileAppender;
import ch.rakudave.jnetmap.util.logging.ListenerAppender;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class LoggingPanel
extends PreferencePanel {
    private HashMap<Appender, JComboBox> hm = new HashMap();

    public LoggingPanel() {
        this.title = Lang.getNoHTML("preferences.logging");
        JPanel comboPanel = new JPanel(new GridLayout(0, 2, 5, 5));
        comboPanel.setMaximumSize(new Dimension(9999, 25));
        for (Appender a : Logger.getAppenders()) {
            if (a instanceof ListenerAppender) continue;
            JComboBox<Logger.Level> cb = new JComboBox<Logger.Level>(Logger.Level.values());
            cb.setSelectedItem((Object)a.getLevel());
            comboPanel.add(new JLabel(a.getClass().getSimpleName().replace("Appender", "")));
            comboPanel.add(cb);
            if (a instanceof FileAppender) {
                comboPanel.add(new JLabel());
                comboPanel.add(new JButton(new AbstractAction(Lang.get("preferences.logging.open"), Icons.get("notes")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Desktop.getDesktop().open(FileAppender.logfile);
                        }
                        catch (IOException e1) {
                            Logger.error("Unable to open logfile " + FileAppender.logfile, e1);
                        }
                    }
                }));
            }
            this.hm.put(a, cb);
        }
        JTextPane legend = new JTextPane();
        legend.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("preferences.legend")));
        legend.setMaximumSize(new Dimension(9999, 25));
        legend.setFocusable(false);
        legend.setBackground(new Color(this.getBackground().getRGB()));
        StringBuilder sb = new StringBuilder();
        for (Logger.Level l : Logger.Level.values()) {
            sb.append(l.toString()).append("\t").append(Lang.getNoHTML("preferences.logging." + (Object)((Object)l))).append("\n");
        }
        legend.setText(sb.toString());
        this.setLayout(new BoxLayout(this, 1));
        this.add(comboPanel);
        this.add(Box.createVerticalGlue());
        this.add(legend);
    }

    @Override
    public void save() {
        for (Appender a : this.hm.keySet()) {
            Settings.put("logger." + a.getClass().getSimpleName(), this.hm.get(a).getSelectedItem().toString());
        }
    }
}

