/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.jung;

import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.view.jung.EditGraphMousePlugin;
import ch.rakudave.jnetmap.view.jung.PopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.annotations.AnnotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.AbstractModalGraphMouse;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ViewScalingControl;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.plaf.basic.BasicIconFactory;
import org.apache.commons.collections15.Factory;

public class MapGraphMouse
extends AbstractModalGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    private Frame owner;
    protected Factory<Device> vertexFactory;
    protected Factory<Connection> edgeFactory;
    protected EditGraphMousePlugin editingPlugin;
    protected PopupGraphMousePlugin popupEditingPlugin;
    protected AnnotatingGraphMousePlugin<Device, Connection> annotatingPlugin;
    protected MultiLayerTransformer basicTransformer;
    protected RenderContext<Device, Connection> rc;
    protected ViewScalingControl scaler;

    public MapGraphMouse(Frame owner, RenderContext<Device, Connection> rc, ViewScalingControl scaler, Factory<Device> vertexFactory, Factory<Connection> edgeFactory) {
        this(owner, rc, scaler, vertexFactory, edgeFactory, 0.9090909f, 1.1f);
    }

    public MapGraphMouse(Frame owner, RenderContext<Device, Connection> rc, ViewScalingControl scaler, Factory<Device> vertexFactory, Factory<Connection> edgeFactory, float in, float out) {
        super(in, out);
        this.owner = owner;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.rc = rc;
        this.scaler = scaler;
        this.basicTransformer = rc.getMultiLayerTransformer();
        this.loadPlugins();
        this.setModeKeyListener(new ModeKeyAdapter(this));
    }

    @Override
    protected void loadPlugins() {
        this.pickingPlugin = new PickingGraphMousePlugin();
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(16);
        this.scalingPlugin = new ScalingGraphMousePlugin(this.scaler, 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.editingPlugin = new EditGraphMousePlugin(this.owner, this.vertexFactory, this.edgeFactory);
        this.annotatingPlugin = new AnnotatingGraphMousePlugin<Device, Connection>(this.rc);
        this.popupEditingPlugin = new PopupGraphMousePlugin(this.owner, this.vertexFactory);
        this.add(this.scalingPlugin);
        this.add(new TranslatingGraphMousePlugin(8));
        this.setMode(ModalGraphMouse.Mode.EDITING);
    }

    @Override
    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            } else if (mode == ModalGraphMouse.Mode.EDITING) {
                this.setEditingMode();
            } else if (mode == ModalGraphMouse.Mode.ANNOTATING) {
                this.setAnnotatingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem((Object)mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, (Object)mode, 1));
        }
    }

    @Override
    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.editingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
        this.add(this.popupEditingPlugin);
    }

    @Override
    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.editingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
        this.add(this.popupEditingPlugin);
    }

    protected void setEditingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.annotatingPlugin);
        this.add(this.editingPlugin);
        this.add(this.popupEditingPlugin);
    }

    protected void setAnnotatingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.editingPlugin);
        this.remove(this.popupEditingPlugin);
        this.add(this.annotatingPlugin);
    }

    @Override
    public JComboBox getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING, ModalGraphMouse.Mode.EDITING, ModalGraphMouse.Mode.ANNOTATING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        this.modeBox.setSelectedItem((Object)this.mode);
        return this.modeBox;
    }

    @Override
    public JMenu getModeMenu() {
        if (this.modeMenu == null) {
            this.modeMenu = new JMenu();
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
            this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                }
            });
            JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.PICKING);
                }
            });
            JRadioButtonMenuItem editingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.EDITING.toString());
            editingButton.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    this.setMode(ModalGraphMouse.Mode.EDITING);
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            radio.add(editingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.add(editingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                        transformingButton.setSelected(true);
                    } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                        pickingButton.setSelected(true);
                    } else if (e.getItem() == ModalGraphMouse.Mode.EDITING) {
                        editingButton.setSelected(true);
                    }
                }
            });
        }
        return this.modeMenu;
    }

    public AnnotatingGraphMousePlugin<Device, Connection> getAnnotatingPlugin() {
        return this.annotatingPlugin;
    }

    public EditGraphMousePlugin getEditingPlugin() {
        return this.editingPlugin;
    }

    public PopupGraphMousePlugin getPopupEditingPlugin() {
        return this.popupEditingPlugin;
    }

    public static class ModeKeyAdapter
    extends KeyAdapter {
        private char t = (char)116;
        private char p = (char)112;
        private char e = (char)101;
        private char a = (char)97;
        protected ModalGraphMouse graphMouse;

        public ModeKeyAdapter(ModalGraphMouse graphMouse) {
            this.graphMouse = graphMouse;
        }

        public ModeKeyAdapter(char t, char p, char e, char a, ModalGraphMouse graphMouse) {
            this.t = t;
            this.p = p;
            this.e = e;
            this.a = a;
            this.graphMouse = graphMouse;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char keyChar = event.getKeyChar();
            if (keyChar == this.t) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(0));
                this.graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            } else if (keyChar == this.p) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(12));
                this.graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
            } else if (keyChar == this.e) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(ModalGraphMouse.Mode.EDITING);
            } else if (keyChar == this.a) {
                ((Component)event.getSource()).setCursor(Cursor.getPredefinedCursor(1));
                this.graphMouse.setMode(ModalGraphMouse.Mode.ANNOTATING);
            }
        }
    }
}

