/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.jung;

import ch.rakudave.jnetmap.util.Settings;
import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class GridGraphLayout<V, E>
extends AbstractLayout<V, E> {
    public GridGraphLayout(Graph<V, E> graph) {
        super(graph);
    }

    @Override
    public void initialize() {
        int gridSize = Settings.getInt("gridlayout.size", 128);
        HashMap<Double, Double> locations = new HashMap<Double, Double>();
        for (Object v : this.getGraph().getVertices()) {
            Double otherY;
            Object coord = this.transform(v);
            double x = this.roundToGrid(gridSize, ((Point2D)coord).getX());
            double y = this.roundToGrid(gridSize, ((Point2D)coord).getY());
            while ((otherY = (Double)locations.get(x)) != null && y == otherY) {
                if (x < 1280.0) {
                    x += (double)gridSize;
                    continue;
                }
                y += (double)gridSize;
            }
            locations.put(x, y);
            ((Point2D)coord).setLocation(x, y);
        }
    }

    @Override
    public void reset() {
    }

    private double roundToGrid(double gridSize, double n) {
        double offset = n % gridSize;
        if (offset > gridSize / 2.0) {
            return n - offset + gridSize;
        }
        return n - offset;
    }
}

