/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.controller.Actions;
import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.controller.command.CommandHistory;
import ch.rakudave.jnetmap.controller.command.CommandListener;
import ch.rakudave.jnetmap.model.CurrentMapListener;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.jung.EditModeListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class ToolBar
extends JToolBar
implements CurrentMapListener,
CommandListener,
EditModeListener {
    public static final String defaultLayout = "new,open,save,|,undo,redo,|,map.pick,map.edit,map.transform,|,refresh,map.zoomin,map.zoomout,-,hamburger";
    private static final String identifierRegex = "[a-zA-Z\\.]*";
    private static ToolBar instance;
    private static final HashMap<String, Action> actions;
    private CommandHistory commandHistory;
    private JButton undo;
    private JButton redo;
    private JButton mode_pick;
    private JButton mode_edit;
    private JButton mode_transform;

    private ToolBar() {
        super(Settings.getInt("toolbar.orientation", 0));
        this.setVisible(Settings.getBoolean("toolbar.visible", true));
        actions.put("new", Actions.newMap(Lang.get("menu.file.new")));
        actions.put("open", Actions.open(Lang.get("menu.file.open")));
        actions.put("save", Actions.save());
        actions.put("saveas", Actions.saveAs());
        actions.put("doc", Actions.viewDoc(Lang.get("menu.help.doc")));
        actions.put("undo", Actions.undo());
        actions.put("redo", Actions.redo());
        actions.put("refresh", Actions.refresh());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ToolBar getInstance() {
        if (instance == null) {
            HashMap<String, Action> hashMap = actions;
            synchronized (hashMap) {
                if (instance == null) {
                    instance = new ToolBar();
                    instance.rebuildToolbarLayout();
                    Controller.addCurrentMapListener(instance);
                    TabPanel.addEditModeListener(instance);
                }
            }
        }
        return instance;
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        Settings.put("toolbar.visible", aFlag);
    }

    @Override
    public void setOrientation(int o) {
        super.setOrientation(o);
        Settings.put("toolbar.orientation", o);
    }

    public boolean add(String identifier, Action action) {
        if (identifier == null || action == null || actions.containsKey(identifier) || !identifier.matches(identifierRegex)) {
            return false;
        }
        actions.put(identifier, action);
        this.rebuildToolbarLayout();
        return true;
    }

    public void remove(String identifier) {
        actions.remove(identifier);
    }

    public HashMap<String, Action> getActions() {
        return (HashMap)actions.clone();
    }

    public synchronized void rebuildToolbarLayout() {
        instance.removeAll();
        List<String> layout = Arrays.asList(Settings.get("toolbar.layout", defaultLayout).split(","));
        for (String id : layout) {
            if ("|".equals(id)) {
                instance.addSeparator();
                continue;
            }
            if ("-".equals(id)) {
                instance.add(Box.createHorizontalGlue());
                continue;
            }
            if (!id.matches(identifierRegex) || !layout.contains(id) || !actions.containsKey(id)) continue;
            Action a = actions.get(id);
            JButton b = new JButton(a);
            if (!Settings.getBoolean("toolbar.labels", false)) {
                b.setText("");
                b.setToolTipText((String)a.getValue("Name"));
            }
            switch (id) {
                case "undo": {
                    this.undo = b;
                    break;
                }
                case "redo": {
                    this.redo = b;
                    break;
                }
                case "map.pick": {
                    this.mode_pick = b;
                    break;
                }
                case "map.edit": {
                    this.mode_edit = b;
                    break;
                }
                case "map.transform": {
                    this.mode_transform = b;
                }
            }
            instance.add(b);
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    @Override
    public void executed(Command c) {
        if (this.redo != null) {
            this.redo.setEnabled(false);
        }
        if (this.undo != null) {
            this.undo.setEnabled(true);
        }
    }

    @Override
    public void undone(Command command) {
        if (this.redo != null) {
            this.redo.setEnabled(true);
        }
        if (this.undo != null) {
            this.undo.setEnabled(this.commandHistory.canUndo());
        }
    }

    @Override
    public void redone(Command command) {
        if (this.redo != null) {
            this.redo.setEnabled(this.commandHistory.canRedo());
        }
        if (this.undo != null) {
            this.undo.setEnabled(true);
        }
    }

    @Override
    public void mapChanged(Map map) {
        if (this.commandHistory != null) {
            this.commandHistory.removeCommandListener(this);
        }
        this.commandHistory = map.getHistory();
        this.commandHistory.addCommandListener(this);
        if (this.redo != null) {
            this.redo.setEnabled(this.commandHistory.canRedo());
        }
        if (this.undo != null) {
            this.undo.setEnabled(this.commandHistory.canUndo());
        }
    }

    @Override
    public void editModeChanged(ModalGraphMouse.Mode mode) {
        this.mode_pick.setEnabled(!ModalGraphMouse.Mode.PICKING.equals((Object)mode));
        this.mode_edit.setEnabled(!ModalGraphMouse.Mode.EDITING.equals((Object)mode));
        this.mode_transform.setEnabled(!ModalGraphMouse.Mode.TRANSFORMING.equals((Object)mode));
    }

    static {
        actions = new HashMap();
    }
}

