/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class SplashScreen {
    private static JFrame frame;
    private static JProgressBar progress;

    public static void create() {
        if (frame != null) {
            return;
        }
        JLabel l = new JLabel(new ImageIcon(SplashScreen.class.getResource("/img/splash.png")));
        progress = new JProgressBar(0, 0, 100);
        progress.setStringPainted(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        frame = new JFrame();
        frame.setTitle("jNetMap - loading...");
        frame.setIconImage(new ImageIcon(SplashScreen.class.getResource("/icons/Tango/jnetmap.png")).getImage());
        frame.setResizable(false);
        frame.setEnabled(false);
        frame.setUndecorated(true);
        frame.setLayout(new BorderLayout());
        frame.getContentPane().add((Component)l, "Center");
        frame.getContentPane().add((Component)progress, "South");
        frame.pack();
        frame.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        frame.setVisible(true);
    }

    public static void dispose() {
        if (frame != null) {
            frame.dispose();
        }
        frame = null;
    }

    public static void setProgress(int percent) {
        if (progress != null) {
            progress.setValue(percent);
        }
    }

    public static void setProgress(int percent, String message) {
        SplashScreen.setProgress(percent);
        SplashScreen.setProgress(message);
    }

    public static void setProgress(String message) {
        if (progress != null) {
            progress.setString(message);
        }
    }
}

