/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.net.NetworkScan;
import ch.rakudave.jnetmap.net.Subnet;
import ch.rakudave.jnetmap.net.status.PingMethod;
import ch.rakudave.jnetmap.util.AlphanumComparator;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.EscapableDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class NetworkScanner
extends EscapableDialog {
    private NetworkScan netScan;
    private AlphanumComparator alphaComp = new AlphanumComparator();

    public NetworkScanner(Frame owner, Map map) {
        super((Window)owner, Lang.getNoHTML("network.scanner"));
        NetworkScanner _this = this;
        this.setLayout(new BorderLayout(5, 5));
        this.setPreferredSize(new Dimension(500, 500));
        this.setMinimumSize(new Dimension(500, 500));
        JPanel main = new JPanel(new BorderLayout(5, 5));
        JList list = new JList();
        list.setCellRenderer(new CheckListRenderer());
        list.addListSelectionListener(e -> {
            if (list.getSelectedValue() != null) {
                JCheckBox c;
                c.setSelected(!(c = (JCheckBox)list.getSelectedValue()).isSelected());
            }
            list.clearSelection();
        });
        Vector checkboxes = new Vector();
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel topInner = new JPanel(new GridLayout(2, 1, 5, 5));
        final JTextField addr = new JTextField(NetworkScan.getLocalAddress());
        final JTextField sub = new JTextField();
        addr.setToolTipText(Lang.get("network.scanner.address"));
        addr.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (sub.getText().isEmpty()) {
                    NetworkScanner.this.autoFill(addr, sub);
                }
            }
        });
        addr.addActionListener(e -> this.autoFill(addr, sub));
        sub.setToolTipText(Lang.get("network.scanner.netmask"));
        this.autoFill(addr, sub);
        topInner.add(addr);
        topInner.add(sub);
        JButton scan = new JButton(Lang.get("port.scan"));
        scan.addActionListener(e -> {
            try {
                if (this.netScan != null) {
                    return;
                }
                scan.setEnabled(false);
                this.netScan = new NetworkScan(new Subnet(addr.getText(), sub.getText()), e12 -> {
                    InetAddress address = (InetAddress)((Tuple)e12.getSource()).getFirst();
                    JCheckBox c = new JCheckBox(address.getHostAddress(), true);
                    c.setToolTipText(Lang.get("action.add"));
                    checkboxes.add(c);
                    if (NetworkScan.tryFindIP(map, address) != null) {
                        c.setEnabled(false);
                        c.setSelected(false);
                    }
                    Collections.sort(checkboxes, (o1, o2) -> this.alphaComp.compare(o1.getText(), o2.getText()));
                    list.setListData(checkboxes);
                });
                Scheduler.execute(() -> this.netScan.start(true));
                Scheduler.execute(() -> {
                    scan.setIcon(Icons.get("busy"));
                    scan.setText("");
                    while (!this.netScan.isDone()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e1) {
                            Logger.debug("Interrupted", e1);
                        }
                    }
                    scan.setIcon(null);
                    scan.setText(Lang.get("action.done"));
                });
            }
            catch (Exception ex) {
                Logger.error("Unable to conduct NetScan", ex);
            }
        });
        topPanel.add((Component)topInner, "Center");
        topPanel.add((Component)scan, "East");
        main.add((Component)topPanel, "North");
        main.add(new JScrollPane(list));
        JPanel bottomRow = new JPanel(new FlowLayout(4, 5, 5));
        JButton cancel = new JButton(Lang.get("action.cancel"), Icons.get("cancel"));
        cancel.addActionListener(e -> {
            if (this.netScan != null) {
                this.netScan.cancel();
            }
            _this.dispose();
        });
        JButton ok = new JButton(Lang.get("action.add"), Icons.get("add"));
        ok.addActionListener(e -> {
            if (this.netScan != null) {
                ok.setEnabled(false);
                if (!this.netScan.isDone()) {
                    this.netScan.cancel();
                }
                HashMap<InetAddress, PingMethod> hosts = new HashMap<InetAddress, PingMethod>(this.netScan.getFoundHosts());
                for (JCheckBox c : checkboxes) {
                    if (c.isSelected()) continue;
                    try {
                        hosts.remove(InetAddress.getByName(c.getText()));
                    }
                    catch (UnknownHostException ex) {
                        Logger.warn("Failed to remove INetAddress ", ex);
                    }
                }
                Logger.debug("Adding to Map: " + Arrays.toString(hosts.keySet().toArray()));
                this.netScan.addToMap(hosts, map);
                _this.dispose();
            }
        });
        bottomRow.add(cancel);
        bottomRow.add(ok);
        this.add((Component)main, "Center");
        this.add((Component)bottomRow, "South");
        this.pack();
        SwingHelper.centerTo(owner, this);
        this.setVisible(true);
    }

    private void autoFill(JTextField address, JTextField subnet) {
        try {
            Subnet s = new Subnet(address.getText().contains("/") ? address.getText() : address.getText() + "/24");
            address.setText(s.getInfo().getLowAddress());
            subnet.setText(s.getInfo().getNetmask());
        }
        catch (Exception e) {
            Logger.warn("Unable to autoFill address " + address.getText(), e);
        }
    }

    private class CheckListRenderer
    implements ListCellRenderer {
        private CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            return (Component)value;
        }
    }
}

