/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util.logging;

import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.logging.Appender;
import ch.rakudave.jnetmap.util.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class FileAppender
extends Appender {
    public static final File logfile = new File(IO.userDir, "logfile.txt");
    private PrintWriter writer;

    public FileAppender(Logger.Level level) {
        this.setLevel(level);
        try {
            if (!logfile.exists()) {
                logfile.createNewFile();
            }
            this.writer = new PrintWriter(new FileOutputStream(logfile, true), true);
        }
        catch (IOException e) {
            Logger.error("Unable to create logfile " + logfile.getAbsolutePath(), e);
        }
    }

    @Override
    void append(Logger.Level l, String message, Throwable t) {
        if (this.level.compareTo(l) >= 0 && this.writer != null) {
            this.writer.println(this.format(l, message));
            if (t != null) {
                t.printStackTrace(this.writer);
            }
            this.writer.flush();
        }
    }
}

