/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util;

import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import java.io.IOException;
import java.util.Properties;
import org.jsoup.Jsoup;

public class Lang {
    private static Properties lang;
    private static Properties fallback;
    private static String currentLanguage;
    private static String fallbackLanguage;

    public static String currentLanguage() {
        return currentLanguage;
    }

    public static String get(String key) {
        String value;
        if (lang == null) {
            Lang.load();
        }
        if ((value = lang.getProperty(key)) == null) {
            Logger.debug("No translation for " + key + " in " + currentLanguage);
            if (fallback != null) {
                value = fallback.getProperty(key);
            }
            if (value == null) {
                Logger.warn("No translation for " + key);
                return key;
            }
        }
        return value;
    }

    public static String[] getLanguages() {
        return IO.listFiles("/lang", false).toArray(new String[0]);
    }

    public static String getNoHTML(String key) {
        return Jsoup.parse(Lang.get(key)).text();
    }

    public static void load() {
        Lang.load(currentLanguage);
    }

    public static synchronized void load(String language) {
        Logger.info("Loading language: " + language);
        if (fallback == null && !fallbackLanguage.equals(language)) {
            fallback = new Properties();
            Lang.load(fallbackLanguage);
            fallback = lang;
        }
        try {
            lang = IO.getMergedProps("/lang/" + language);
            for (Object key : lang.keySet()) {
                String value = new String(((String)lang.get(key)).getBytes("iso8859-1"), "utf-8");
                lang.put(key, "<html>" + value + "</html>");
            }
            currentLanguage = language;
            Settings.put("lang", currentLanguage);
        }
        catch (IOException e) {
            Logger.error("Failed to open language-file " + language, e);
        }
    }

    private Lang() {
    }

    static {
        currentLanguage = Settings.get("lang", "English");
        fallbackLanguage = "English";
    }
}

