/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.net.status;

import ch.rakudave.jnetmap.net.status.PingMethod;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

@XStreamAlias(value="OpenSocket")
public class OpenSocket
implements PingMethod {
    private int port;

    public OpenSocket() throws IllegalArgumentException {
        this(0);
    }

    public OpenSocket(int port) throws IllegalArgumentException {
        if (port < 0 | port > 65535) {
            throw new IllegalArgumentException();
        }
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Status getStatus(InetAddress address) {
        int timeout = Settings.getInt("socket.timeout", Settings.getInt("ping.timeout", 5000));
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(address, this.port), timeout);
            socket.close();
            Status status = Status.UP;
            return status;
        }
        catch (SocketTimeoutException e) {
            Logger.trace(address + " timed out after " + timeout, e);
            Status status = Status.DOWN;
            return status;
        }
        catch (SocketException e) {
            Logger.trace("Can't connect to " + address, e);
            Status status = Status.DOWN;
            return status;
        }
        catch (Exception e2) {
            Logger.trace("Failed to get port status for " + address, e2);
            Status status = Status.UNKNOWN;
            return status;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "TCP Port";
    }
}

