/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.net.status;

import ch.rakudave.jnetmap.net.status.PingMethod;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.InetAddress;

@XStreamAlias(value="NativePing")
public class NativePing
implements PingMethod {
    private static NativePing instance;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativePing getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new NativePing();
                }
            }
        }
        return instance;
    }

    protected NativePing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status getStatus(InetAddress address) {
        Process process = null;
        try {
            String command = IO.isUnix ? Settings.get("ping.syntax.unix", "ping -c 4 -w 5") : Settings.get("ping.syntax.windows", "ping -w 1250");
            process = Runtime.getRuntime().exec(command + " " + address.getHostAddress());
            Status status = process.waitFor() == 0 ? Status.UP : Status.DOWN;
            return status;
        }
        catch (Exception e) {
            Logger.trace("Failed to get native ping status " + address, e);
            Status status = Status.UNKNOWN;
            return status;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public String toString() {
        return "System Ping";
    }

    static {
        lock = new Object();
    }
}

