/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.controller;

import ch.rakudave.jnetmap.controller.Actions;
import ch.rakudave.jnetmap.controller.InstanceDetector;
import ch.rakudave.jnetmap.controller.RecentlyOpened;
import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.controller.StatusUpdater;
import ch.rakudave.jnetmap.model.CurrentMapListener;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.model.MapEvent;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.util.Crypto;
import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.util.XStreamHelper;
import ch.rakudave.jnetmap.util.logging.FileAppender;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.IView;
import ch.rakudave.jnetmap.view.MapView;
import ch.rakudave.jnetmap.view.components.StatusBar;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.pf4j.DefaultPluginManager;
import org.pf4j.PluginManager;
import ro.fortsoft.pf4j.util.StringUtils;

public class Controller {
    public static final String version = "0.5.5";
    private static IView view;
    private static PluginManager pluginManager;
    private static List<Map> maps;
    private static Map currentMap;
    private static List<CurrentMapListener> currentMapListeners;

    public static void main(String[] args) {
        try {
            Options options = new Options();
            options.addOption("i", "new-instance", false, "launch new instance instead of trying to delegate");
            options.addOption("n", "new", false, "open a new map");
            options.addOption("o", "open", false, "open a file chooser to select a map to be opened");
            options.addOption("c", "close", false, "close an already running instance and exit");
            options.addOption("v", "version", false, "display the version number and exit");
            options.addOption("h", "help", false, "display this message and exit");
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (cmd.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("jnetmap [OPTIONS] [files]", options);
                System.exit(0);
            } else if (cmd.hasOption("v")) {
                System.out.println(version);
                System.exit(0);
            } else if (GraphicsEnvironment.isHeadless()) {
                Logger.fatal("No graphics environment found, exiting");
                System.exit(1);
            }
            if (!cmd.hasOption("i")) {
                InstanceDetector.delegate(cmd);
            }
            new Controller(cmd);
        }
        catch (Throwable t) {
            Logger.error("Unhandled exception", t);
            t.printStackTrace();
        }
    }

    private Controller(CommandLine cmd) {
        Scheduler.executor = new ScheduledThreadPoolExecutor(3);
        maps = new ArrayList<Map>();
        currentMapListeners = new ArrayList<CurrentMapListener>();
        IO.updateUserFiles();
        Settings.load();
        Logger.addAppender(new FileAppender(Logger.Level.valueOf(Settings.get("logger.FileAppender", "ERROR"))));
        Logger.debug(System.getProperty("java.runtime.name") + " " + System.getProperty("java.version") + " (" + System.getProperty("sun.arch.data.model") + "bit)");
        Logger.debug("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        Lang.load();
        Icons.load();
        this.setLookAndFeel();
        try {
            pluginManager = new DefaultPluginManager(new File(IO.userDir, "/plugins").toPath());
            pluginManager.loadPlugins();
            pluginManager.startPlugins();
        }
        catch (Exception e) {
            Logger.fatal("Failed to load plugins", e);
        }
        RecentlyOpened.load();
        view = new MapView();
        StatusBar.getInstance().setMessage(Lang.get("message.status.welcome"));
        Controller.openRequestedFiles(cmd, false);
        Logger.info("Ready");
        view.toFront();
    }

    private void setLookAndFeel() {
        try {
            if (IO.isOSX) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
            UIManager.setLookAndFeel(Settings.get("laf.theme", UIManager.getSystemLookAndFeelClassName()));
            String fontName = Settings.get("view.font.name", "");
            if (StringUtils.isNotEmpty(fontName)) {
                SwingHelper.setUIFont(fontName, Settings.getInt("view.font.size", 14));
            }
        }
        catch (Exception e) {
            Logger.warn("Unable to set 'System Look-And-Feel', falling back to Swing", e);
        }
    }

    static void openRequestedFiles(CommandLine cmd, boolean isDelegate) {
        List<String> files;
        Object[] o;
        if (view != null) {
            view.toFront();
        }
        if (cmd.hasOption("n")) {
            Controller.getView().openMap(new Map());
        }
        if (cmd.hasOption("o") && (o = SwingHelper.openDialog((Component)((Object)Controller.getView()), new FileNameExtensionFilter("jNetMap file *.jnm", "jnm"), true)) != null && o.length > 0 && o[0] != null) {
            Controller.open(Controller.getMapFromFile(((File)o[0]).getAbsolutePath(), null));
        }
        if ((files = cmd.getArgList()).isEmpty() && !isDelegate && Settings.getBoolean("maps.restore", false)) {
            for (int i = 0; i < Settings.getInt("maps.count", 0); ++i) {
                files.add(Settings.get("maps." + i, ""));
            }
        }
        files.forEach(file -> {
            StatusBar.getInstance().setMessage("Opening " + file + " ...");
            Controller.open(Controller.getMapFromFile(file, null));
        });
    }

    public static boolean open(Map map) {
        if (map == null) {
            return false;
        }
        Logger.info("Opening '" + map.getFileName() + "'");
        if (maps.contains(map)) {
            Logger.warn("Map is already open: " + map.getFileName());
            return true;
        }
        try {
            StatusBar.getInstance().setMessage(Lang.getNoHTML("message.status.opening").replace("%name%", map.getFileName()));
            view.openMap(map);
            Controller.setCurrentMap(map);
            return true;
        }
        catch (Exception e) {
            Logger.error("Unable to open " + map.getFileName(), e);
            StatusBar.getInstance().clearMessage();
            JOptionPane.showMessageDialog((Component)((Object)view), Lang.get("map.fail.open"), map.getFileName(), 0);
            return false;
        }
    }

    public static Map getMapFromFile(String filePath, String password) {
        try {
            File mapFile = new File(filePath);
            String xml = IO.getString(mapFile);
            if (xml == null || xml.isEmpty()) {
                throw new Exception("File '" + filePath + "' was empty");
            }
            if (!xml.startsWith("<Map>") && (password == null || password.isEmpty()) && (password = SwingHelper.passwordPrompt()) == null) {
                return null;
            }
            if (password != null && !password.isEmpty()) {
                xml = Crypto.decrypt(xml, password);
            }
            Map m = (Map)XStreamHelper.getXStream().fromXML(xml);
            m.setFile(mapFile);
            m.setPassword(password);
            RecentlyOpened.put(mapFile);
            return m;
        }
        catch (Exception e) {
            Logger.error("Could not open file '" + filePath + "'", e);
            return null;
        }
    }

    public static boolean close(Map map) {
        if (map == null || !maps.contains(map)) {
            return true;
        }
        Logger.trace("Closing map " + map);
        if (!map.isSaved()) {
            String msg = Lang.get("message.unsaved").replaceAll("%name%", map.getFileName());
            int i = JOptionPane.showConfirmDialog((Component)((Object)view), msg, map.getFilePath(), 1, 3);
            switch (i) {
                case 2: {
                    return false;
                }
                case 0: {
                    Controller.setStatusUnknownAndSave(map);
                    break;
                }
            }
        } else {
            Controller.setStatusUnknownAndSave(map);
        }
        maps.remove(map);
        return true;
    }

    private static void setStatusUnknownAndSave(Map map) {
        for (Device d : map.getVertices()) {
            d.addStatusUnknownToHistory();
        }
        Controller.setCurrentMap(map);
        Actions.save().actionPerformed(null);
    }

    public static void setCurrentMap(Map map) {
        if (!maps.contains(currentMap)) {
            maps.add(map);
            StatusUpdater.addMap(map);
        }
        currentMap = map;
        view.setWindowTitle(map.getFilePath());
        for (CurrentMapListener listener : currentMapListeners) {
            try {
                listener.mapChanged(map);
            }
            catch (Throwable t) {
                Logger.warn("Failed to notify currentMapListener", t);
            }
        }
    }

    public static Map getCurrentMap() {
        return currentMap;
    }

    public static void addCurrentMapListener(CurrentMapListener listener) {
        currentMapListeners.add(listener);
    }

    public static void removeCurrentMapListener(CurrentMapListener listener) {
        currentMapListeners.remove(listener);
    }

    private static boolean closeAllMaps() {
        ArrayList<Map> tempMaps = new ArrayList<Map>(maps);
        boolean restore = Settings.getBoolean("maps.restore", false);
        Settings.removeAll("maps.");
        int i = 0;
        for (Map m : tempMaps) {
            if (!Controller.close(m)) {
                return false;
            }
            if (m.getFileName().equals(Lang.getNoHTML("map.newmap"))) continue;
            Settings.put("maps." + i++, m.getFilePath());
        }
        Settings.put("maps.count", i);
        Settings.put("maps.restore", restore);
        return true;
    }

    static void shutdown(boolean restart) {
        if (!Controller.closeAllMaps()) {
            return;
        }
        RecentlyOpened.save();
        view.saveViewProperties();
        Settings.save();
        view.dispose();
        Logger.info("Shutting down...");
        Scheduler.executor.shutdown();
        try {
            Scheduler.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.debug("Shutdown interrupted", e);
        }
        if (restart) {
            try {
                new Controller(new DefaultParser().parse(new Options(), new String[0]));
            }
            catch (ParseException e) {
                Logger.error("Failed to restart", e);
            }
        } else {
            System.exit(0);
        }
    }

    public static IView getView() {
        return view;
    }

    public static void refreshAll() {
        for (Map m : maps) {
            m.refreshView(MapEvent.Type.SETTINGS_CHANGED);
        }
    }

    public static PluginManager getPluginManager() {
        return pluginManager;
    }
}

