/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.AvailableCharsets;
import entities.DictionaryRule;
import java.util.ArrayList;
import java.util.List;

public class DictionaryRulePreProcessor {
    private int min_length = 4;
    private int max_length = 16;
    private static DictionaryRulePreProcessor instance;

    private DictionaryRulePreProcessor() {
    }

    private DictionaryRulePreProcessor(int min_length, int max_length) {
        this.min_length = min_length;
        this.max_length = max_length;
    }

    public static DictionaryRulePreProcessor getInstance() {
        if (instance == null) {
            instance = new DictionaryRulePreProcessor();
        }
        return instance;
    }

    public int getMin_length() {
        return this.min_length;
    }

    public void setMin_length(int min_length) {
        this.min_length = min_length;
    }

    public int getMax_length() {
        return this.max_length;
    }

    public void setMax_length(int max_length) {
        this.max_length = max_length;
    }

    public List<String> getRuleConditions(String s) {
        ArrayList<String> returnValue = new ArrayList<String>();
        List<String> myWords = this.getWordList(s);
        for (String word : myWords) {
            if (!this.isCondition(word)) continue;
            returnValue.add(word);
        }
        return returnValue;
    }

    public List<String> getRuleActions(String s) {
        ArrayList<String> returnValue = new ArrayList<String>();
        List<String> myWords = this.getWordList(s);
        for (String word : myWords) {
            if (!this.isAction(word)) continue;
            returnValue.add(word);
        }
        return returnValue;
    }

    public final boolean mustMemorizeWord(String action) {
        return action.equals("M");
    }

    public final boolean isAction(String s) {
        boolean returnValue = false;
        char c = s.charAt(0);
        if (c == 's' || c == '@' || c == 'S' || c == 'V' || c == 'R' || c == 'L' || c == 'p' || c == 'P' || c == 'I' || c == '\'' || c == ':' || c == 'l' || c == 'u' || c == 'c' || c == 'C' || c == 't' || c == 'T' || c == 'r' || c == 'd' || c == 'f' || c == '{' || c == '}' || c == '$' || c == '^' || c == '[' || c == ']' || c == 'D' || c == 'M' || c == 'X') {
            returnValue = true;
        }
        return returnValue;
    }

    public final boolean isCondition(String s) {
        char c2;
        boolean returnValue = false;
        char c1 = s.charAt(0);
        if (c1 == '>' || c1 == '<' || c1 == '!' || c1 == '/' || c1 == '=' || c1 == '(' || c1 == ')' || c1 == '%' || c1 == 'Q') {
            returnValue = true;
        } else if (c1 == '-' && s.length() > 1 && ((c2 = s.charAt(1)) == ':' || c2 == 'c' || c2 == '8' || c2 == 's' || c2 == 'p')) {
            returnValue = true;
        }
        return returnValue;
    }

    public boolean isValidRule(String s) {
        boolean returnValue = true;
        List<String> words = this.getWordList(s);
        for (String elem : words) {
            if (this.isCondition(elem) || this.isAction(elem)) continue;
            returnValue = false;
            break;
        }
        return returnValue;
    }

    public List<String> getWordList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        int lineLength = s.length();
        StringBuilder aux = new StringBuilder("");
        while (count < lineLength) {
            if (s.charAt(count) == ' ') {
                list.add(aux.toString());
                aux = new StringBuilder("");
                while (count < lineLength && s.charAt(count) == ' ') {
                    ++count;
                }
                continue;
            }
            aux.append(s.charAt(count));
            ++count;
        }
        if (aux.length() > 0) {
            list.add(aux.toString());
        }
        return list;
    }

    public boolean isMaskedAction(String action) {
        boolean returnValue = false;
        if (this.isAction(action)) {
            String mask = this.removeAction(action);
            int lastCharPosition = mask.length() - 1;
            if (mask.charAt(0) == '[' && mask.charAt(lastCharPosition) == ']') {
                returnValue = true;
            }
        }
        return returnValue;
    }

    private String removeAction(String action) {
        char c = action.charAt(0);
        String returnValue = action;
        returnValue = c == '$' || c == '^' ? action.substring(1, action.length()) : action;
        return returnValue;
    }

    public char[] getTargets(String action) {
        char[] returnValue = null;
        int maskSize = action.length() - 2;
        if (action.length() == 0 || action.charAt(0) != '[' || action.charAt(maskSize + 1) != ']') {
            return returnValue;
        }
        StringBuilder aux = new StringBuilder();
        aux.append(action);
        aux.deleteCharAt(action.length() - 1);
        aux.deleteCharAt(0);
        String mask = aux.toString();
        if (mask.equals("a-z") && mask.length() == 3) {
            returnValue = AvailableCharsets.getCharsetByName("loweralpha").toCharArray();
        } else if (mask.equals("A-Z") && mask.length() == 3) {
            returnValue = AvailableCharsets.getCharsetByName("alpha").toCharArray();
        } else if (mask.equals("0-9") && mask.length() == 3) {
            returnValue = AvailableCharsets.getCharsetByName("numeric").toCharArray();
        } else if (mask.equals("a-zA-Z") && mask.length() == 6) {
            returnValue = AvailableCharsets.getCharsetByName("mixalpha").toCharArray();
        } else if (mask.equals("a-z0-9") && mask.length() == 6) {
            returnValue = AvailableCharsets.getCharsetByName("loweralpha-numeric").toCharArray();
        } else if (mask.equals("A-Z0-9") && mask.length() == 6) {
            returnValue = AvailableCharsets.getCharsetByName("alpha-numeric").toCharArray();
        } else if (mask.equals("a-zA-Z0-9") && mask.length() == 9) {
            returnValue = AvailableCharsets.getCharsetByName("mixalpha-numeric").toCharArray();
        } else {
            int auxIndex = 0;
            returnValue = new char[maskSize];
            int i = 0;
            while (i < mask.length()) {
                returnValue[auxIndex] = mask.charAt(i);
                ++auxIndex;
                ++i;
            }
        }
        return returnValue;
    }

    public List<DictionaryRule> generateSubRules(List<String> operands) {
        ArrayList<DictionaryRule> returnValue = new ArrayList<DictionaryRule>();
        DictionaryRule dr = new DictionaryRule();
        returnValue.add(dr);
        ArrayList<DictionaryRule> aux = null;
        for (String operand : operands) {
            if (this.isMaskedAction(operand)) {
                String mask = this.removeAction(operand);
                char c = operand.charAt(0);
                char[] maskMembers = this.getTargets(mask);
                aux = new ArrayList<DictionaryRule>();
                for (DictionaryRule rule : returnValue) {
                    int i = 0;
                    while (i < maskMembers.length) {
                        String actionsLine = rule.toString();
                        dr = new DictionaryRule(actionsLine);
                        StringBuilder auxsb = new StringBuilder();
                        auxsb.append(c);
                        auxsb.append(maskMembers[i]);
                        dr.addMember(auxsb.toString());
                        aux.add(dr);
                        ++i;
                    }
                }
                returnValue = aux;
                continue;
            }
            for (DictionaryRule rule : returnValue) {
                rule.addMember(operand);
            }
        }
        return returnValue;
    }

    public final List<DictionaryRule> getRulesFromRuleLines(List<String> ruleLines, boolean printRulesLoaded) {
        ArrayList<DictionaryRule> rules = new ArrayList<DictionaryRule>();
        if (printRulesLoaded) {
            System.out.print("Loading rules... ");
        }
        for (String rule : ruleLines) {
            if (this.isValidRule(rule)) {
                rules.add(new DictionaryRule(rule));
                continue;
            }
            if (!printRulesLoaded) continue;
            System.out.println("Error! invalid rule: " + rule + " (ignored)");
        }
        if (rules.size() == 0) {
            rules.add(new DictionaryRule(":"));
            if (printRulesLoaded) {
                System.out.println("Using default rule \":\" (just use words in dictionary)");
            }
        } else if (printRulesLoaded) {
            System.out.println(String.valueOf(rules.size()) + " rules loaded.");
        }
        return rules;
    }

    public boolean mustQueryMemory(String condition) {
        return condition.equals("Q");
    }
}

