/*
 * Decompiled with CFR 0.152.
 */
package entities;

import entities.DictionaryRulePreProcessor;
import entities.DictionaryRuleProcessor;
import java.util.ArrayList;
import java.util.List;

public class DictionaryRule {
    private List<String> conditions = new ArrayList<String>();
    private List<String> actions = new ArrayList<String>();
    private List<String> members = new ArrayList<String>();
    private DictionaryRuleProcessor rp = new DictionaryRuleProcessor();
    private DictionaryRulePreProcessor rpp = DictionaryRulePreProcessor.getInstance();
    private String oneLineDefinition;
    private List<DictionaryRule> subRules;

    public DictionaryRule() {
    }

    public DictionaryRule(String rule) {
        this.oneLineDefinition = rule;
        this.conditions = this.rpp.getRuleConditions(this.oneLineDefinition);
        this.actions = this.rpp.getRuleActions(this.oneLineDefinition);
        this.members = this.rpp.getWordList(this.oneLineDefinition);
        this.subRules = this.rpp.generateSubRules(this.members);
    }

    public List<String> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<String> conditions) {
        this.conditions = conditions;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public void setMembers(List<String> members) {
        this.members = members;
    }

    public boolean rejectWord(StringBuilder word) {
        return this.rp.rejectConditionList(this.conditions, word);
    }

    private StringBuilder aplicateOneAction(StringBuilder word) {
        return this.rp.applyRuleActionList(word, this.actions);
    }

    public String toString() {
        StringBuilder aux = new StringBuilder();
        for (String member : this.members) {
            aux.append(member);
            aux.append(" ");
        }
        int myLength = aux.length();
        if (myLength > 0 && aux.charAt(myLength - 1) == ' ') {
            aux.deleteCharAt(aux.length() - 1);
        }
        return aux.toString();
    }

    public void addAction(String action) {
        this.actions.add(action);
    }

    public void addMember(String action) {
        this.members.add(action);
    }

    public List<String> getSubRules() {
        ArrayList<String> list = new ArrayList<String>();
        for (DictionaryRule dr : this.subRules) {
            list.add(dr.toString());
        }
        return list;
    }

    public List<StringBuilder> aplicateAction(StringBuilder word) {
        ArrayList<StringBuilder> list = new ArrayList<StringBuilder>();
        for (DictionaryRule dr : this.subRules) {
            list.add(dr.aplicateOneAction(word));
        }
        return list;
    }

    public List<StringBuilder> aplicateRule(StringBuilder word) {
        ArrayList<StringBuilder> list = new ArrayList<StringBuilder>();
        StringBuilder aux = null;
        for (DictionaryRule dr : this.subRules) {
            aux = dr.aplicateOneRule(word);
            if (aux == null) continue;
            list.add(aux);
        }
        return list;
    }

    private StringBuilder aplicateOneRule(StringBuilder word) {
        this.rp.setMemory(new StringBuilder(word));
        StringBuilder returnValue = new StringBuilder(word);
        for (String member : this.members) {
            block5: {
                if (!this.rpp.isCondition(member)) break block5;
                if (!this.rp.rejectCondition(member, returnValue)) continue;
                return null;
            }
            try {
                if (this.rpp.isAction(member)) {
                    returnValue = this.rp.applyAction(returnValue, member);
                    continue;
                }
                System.err.println("ERROR!!! unknow member: " + member);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("[DEBUG][aplicateOneRule] rule   : " + this.toString());
                System.err.println("[DEBUG][aplicateOneRule] member : " + member);
                System.err.println("[DEBUG][aplicateOneRule] word   : " + word);
                System.err.println("[DEBUG][aplicateOneRule] memory : " + this.rp.getMemory());
            }
        }
        return returnValue;
    }
}

