/*
 * Decompiled with CFR 0.152.
 */
package controller;

import controller.InParameter;
import entities.AuxiliaryForDecryptThreads;
import entities.AvailableAlgorithms;
import entities.AvailableCharsets;
import entities.ByteArray;
import entities.DictionaryRule;
import entities.DictionaryRulePreProcessor;
import entities.HashEntry;
import entities.IOProcessor;
import entities.JBruteThread;
import entities.MyBruteDecryptThread;
import entities.MyDictionaryDecryptThread;
import entities.ProcessResult;
import entities.WordList;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import specialAlgorithm.MyMessageDigest;

public class JBrute {
    public static void main(String[] args) {
        int argSize = args.length;
        if (argSize <= 0) {
            System.out.println("");
            System.out.println("No arguments passed.");
        } else {
            String mainParameter = args[0];
            ArrayList<InParameter> optionalParameters = new ArrayList<InParameter>();
            int i = 1;
            while (i < argSize) {
                optionalParameters.add(new InParameter(args[i]));
                ++i;
            }
            if (mainParameter.equalsIgnoreCase("--decrypt")) {
                JBrute.mainDecrypt(optionalParameters);
                return;
            }
            if (mainParameter.equalsIgnoreCase("--encrypt")) {
                JBrute.mainEncrypt(optionalParameters);
            } else if (mainParameter.equalsIgnoreCase("--list_charsets")) {
                JBrute.mainListCharsets();
            } else if (mainParameter.equalsIgnoreCase("--help")) {
                JBrute.mainHelp();
            } else if (mainParameter.equalsIgnoreCase("--debug")) {
                System.out.println("");
                System.out.println("No hay ninguna funcion asignada al parametro --debug.");
                System.out.println("");
            } else if (mainParameter.equalsIgnoreCase("--test")) {
                JBrute.mainTest(optionalParameters);
            } else if (mainParameter.equalsIgnoreCase("--optimal_threads")) {
                JBrute.mainOptimalThreads();
            } else if (mainParameter.equalsIgnoreCase("--version")) {
                JBrute.mainVersion();
            } else if (mainParameter.equalsIgnoreCase("--expected")) {
                JBrute.mainExpected();
            } else if (mainParameter.equalsIgnoreCase("--guess")) {
                JBrute.mainGuess(optionalParameters);
            } else {
                System.out.println("");
                System.out.println("Wrong Main Parameter ()" + mainParameter + "!!! Use --help to show available parameters.");
                System.out.println("");
            }
        }
    }

    public static void mainGuess(List<InParameter> optionalParameters) {
        List<String> hashList = new ArrayList<String>();
        boolean hashInputControl1 = false;
        boolean hashInputControl2 = false;
        boolean luckyMode = false;
        for (InParameter parameter : optionalParameters) {
            String encryptedHash;
            if (parameter.getName().equalsIgnoreCase("--hash")) {
                if (!parameter.hasValue()) {
                    System.out.println("");
                    System.err.println("ERROR! You must specify a hash!");
                    System.out.println("");
                    return;
                }
                encryptedHash = parameter.getValue();
                hashList.add(encryptedHash);
                hashInputControl1 = true;
                continue;
            }
            if (parameter.getName().equalsIgnoreCase("--hash_file")) {
                if (parameter.hasValue()) {
                    String hashFileName = parameter.getValue();
                    encryptedHash = "";
                    hashList = IOProcessor.getHashesFromHashFile(hashFileName);
                    hashInputControl2 = true;
                    continue;
                }
                System.out.println("");
                System.err.println("ERROR! You must specify a hash file name!");
                System.out.println("");
                return;
            }
            if (parameter.getName().equalsIgnoreCase("--lucky")) {
                luckyMode = true;
                continue;
            }
            System.out.println("");
            System.out.println("ERROR!!! unknow parameter: " + parameter.getName());
            System.out.println("");
            return;
        }
        if (hashInputControl1 && hashInputControl2) {
            System.out.println("");
            System.err.println("ERROR! You must specify or --hash or --hash_file optional parameters, not both.");
            System.out.println("");
            return;
        }
        if (hashList.size() == 0) {
            System.out.println("");
            System.err.println("ERROR! There are no hashes to guess.");
            System.out.println("");
            return;
        }
        System.out.println("");
        if (luckyMode) {
            System.out.println("Lucky mode: ON");
        }
        System.out.println("My guess is:");
        List<Object> algName = new ArrayList();
        boolean aux = false;
        for (String hash : hashList) {
            algName = AvailableAlgorithms.guessAlgorithms(hash, luckyMode);
            if (algName.size() == 0) {
                System.out.print(String.valueOf(hash) + " : UNKNOW");
                continue;
            }
            System.out.print(String.valueOf(hash) + " : ");
            for (String string : algName) {
                if (!aux) {
                    System.out.print(string);
                    aux = true;
                    continue;
                }
                System.out.print("," + string);
            }
            System.out.println("");
        }
        System.out.println("");
    }

    public static void mainExpected() {
        System.out.println("");
        System.out.println("Printing examples for expected hashes of supported algorithms (no chained)");
        String word = "hola";
        System.out.println("Word to encrypt: " + word);
        System.out.println("");
        byte[] bword = word.getBytes();
        Object result = null;
        String resultHash = "";
        String algName = "";
        String auxSalt = "";
        String[] algorithms = AvailableAlgorithms.getAvailableAlgorithms();
        int i = 0;
        while (i < algorithms.length) {
            if (AvailableAlgorithms.isSupportedAlgorithm(i)) {
                algName = AvailableAlgorithms.getAlgorithmName(i);
                if (AvailableAlgorithms.isHashedSpecialAlgorithm(i)) {
                    auxSalt = "username";
                }
                resultHash = JBrute.encryptWord(word, i, auxSalt);
                System.out.println("Hash " + algName + ": " + resultHash);
            }
            ++i;
        }
        System.out.println("");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static void mainDecrypt(List<InParameter> optionalParameters) {
        block91: {
            block90: {
                block89: {
                    block88: {
                        block87: {
                            block86: {
                                block85: {
                                    result = new ProcessResult();
                                    encryptedHash = new HashEntry();
                                    hashList /* !! */  = new ArrayList<HashEntry>();
                                    hashFileName = null;
                                    charsetName = null;
                                    alphabet = null;
                                    salt = null;
                                    chainedHashCase = "";
                                    decryptionMethod = "brute";
                                    dictionaryFileName = "wordlist.txt";
                                    rulesFileName = "rules.txt";
                                    algorithmCode = "0";
                                    saltType = "utf8";
                                    hashOption = false;
                                    preSalt = false;
                                    stdoutMode = false;
                                    from = 0;
                                    until = 0;
                                    numberOfThreads = 1;
                                    isDefaultCharset = false;
                                    for (InParameter parameter : optionalParameters) {
                                        if (parameter.getName().equalsIgnoreCase("--hash")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a hash!");
                                                System.out.println("");
                                                return;
                                            }
                                            hashOption = true;
                                            encryptedHash.setHash(parameter.getValue());
                                            hashList /* !! */ .add(encryptedHash);
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--algorithm")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct algorithm code.");
                                                System.out.println("");
                                                return;
                                            }
                                            algorithmCode = parameter.getValue();
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--charset")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct charset.");
                                                System.out.println("");
                                                return;
                                            }
                                            charsetName = parameter.getValue();
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--minlength")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct a correct from number.");
                                                System.out.println("");
                                                return;
                                            }
                                            if (!JBrute.isValidWordLengthNumber(parameter.getValue())) {
                                                System.out.println("");
                                                System.out.println("ERROR! Invalid from number: " + parameter.getValue());
                                                System.out.println("");
                                                return;
                                            }
                                            from = parameter.getNumericValue();
                                            if (from != -2147483648) continue;
                                            System.out.println("");
                                            System.out.println("ERROR! Invalid from number: " + parameter.getValue());
                                            System.out.println("");
                                            return;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--maxlength")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct until number.");
                                                System.out.println("");
                                                return;
                                            }
                                            if (!JBrute.isValidWordLengthNumber(parameter.getValue())) {
                                                System.out.println("");
                                                System.out.println("ERROR! Invalid until number: " + parameter.getValue());
                                                System.out.println("");
                                                return;
                                            }
                                            until = parameter.getNumericValue();
                                            if (from != -2147483648) continue;
                                            System.out.println("");
                                            System.out.println("ERROR! Invalid until number: " + parameter.getValue());
                                            System.out.println("");
                                            return;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--hash_file")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a hash file name!!!");
                                                System.out.println("");
                                                return;
                                            }
                                            hashFileName = parameter.getValue();
                                            hashList /* !! */  = IOProcessor.getLinesFromHashFile(hashFileName);
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--threads")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct thread number.");
                                                System.out.println("");
                                                return;
                                            }
                                            if (!JBrute.isValidStringNumber(parameter.getValue())) {
                                                System.out.println("");
                                                System.out.println("ERROR! Invalid threads number: " + parameter.getValue());
                                                System.out.println("");
                                                return;
                                            }
                                            numberOfThreads = parameter.getNumericValue();
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--presalt")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct presalt.");
                                                System.out.println("");
                                                return;
                                            }
                                            salt = parameter.getValue();
                                            preSalt = true;
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--postsalt")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct postsalt.");
                                                System.out.println("");
                                                return;
                                            }
                                            salt = parameter.getValue();
                                            preSalt = false;
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--salt_type")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct salt type.");
                                                System.out.println("");
                                                return;
                                            }
                                            myAux = parameter.getValue();
                                            if (myAux.equalsIgnoreCase("int64")) {
                                                saltType = myAux;
                                                continue;
                                            }
                                            if (myAux.equalsIgnoreCase("hex")) {
                                                saltType = myAux;
                                                continue;
                                            }
                                            if (!myAux.equalsIgnoreCase("utf8")) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct salt type.");
                                                System.out.println("");
                                                return;
                                            }
                                            saltType = myAux;
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--chained_case")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct chained case.");
                                                System.out.println("");
                                                return;
                                            }
                                            chainedHashCase = parameter.getValue();
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--method")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct metod.");
                                                System.out.println("");
                                                return;
                                            }
                                            decryptionMethod = parameter.getValue();
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--dict_file")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct dictionary file name.");
                                                System.out.println("");
                                                return;
                                            }
                                            dictionaryFileName = parameter.getValue();
                                            continue;
                                        }
                                        if (parameter.getName().equalsIgnoreCase("--rule_file")) {
                                            if (!parameter.hasValue()) {
                                                System.out.println("");
                                                System.err.println("ERROR! You must specify a correct rules file name.");
                                                System.out.println("");
                                                return;
                                            }
                                            rulesFileName = parameter.getValue();
                                            continue;
                                        }
                                        if (!parameter.getName().equalsIgnoreCase("--stdout")) {
                                            System.out.println("");
                                            System.out.println("ERROR!!! unknow parameter: " + parameter.getName());
                                            System.out.println("");
                                            return;
                                        }
                                        stdoutMode = true;
                                    }
                                    if (hashFileName != null && hashOption) {
                                        System.out.println("");
                                        System.out.println("You can't use --hash and --hash_file parameters together!!!");
                                        System.out.println("");
                                        return;
                                    }
                                    if (hashOption) {
                                        if (salt != null) {
                                            if (preSalt) {
                                                ((HashEntry)hashList /* !! */ .get(0)).setPreSalt(salt);
                                            } else {
                                                ((HashEntry)hashList /* !! */ .get(0)).setPostSalt(salt);
                                            }
                                            ((HashEntry)hashList /* !! */ .get(0)).setSaltType(saltType);
                                        }
                                    } else if (hashList /* !! */ .size() == 0 && !stdoutMode) {
                                        System.out.println("");
                                        System.out.println("ERROR!!! You must use --hash or --hash_file parameter!!!");
                                        System.out.println("");
                                        return;
                                    }
                                    if (!hashOption && hashFileName == null) {
                                        if (!decryptionMethod.equalsIgnoreCase("dictionary") && !stdoutMode) {
                                            System.out.println("");
                                            System.out.println("You must specify a hash or a hash file!!!");
                                            System.out.println("");
                                            return;
                                        }
                                    } else {
                                        System.out.println("");
                                        for (HashEntry he : hashList /* !! */ ) {
                                            result.addEncryptedHash(he);
                                        }
                                        hashList /* !! */ .clear();
                                    }
                                    if (AvailableAlgorithms.isSupportedAlgorithm(algorithmCode)) break block85;
                                    if (!(stdoutMode && decryptionMethod.equalsIgnoreCase("dictionary") || result.getEncryptedHashes().size() <= 0)) {
                                        if (!algorithmCode.equalsIgnoreCase("0")) {
                                            System.out.println("");
                                            System.out.println("ERROR! Unsupported algorithm!!!");
                                            System.out.println("");
                                            return;
                                        }
                                        System.out.println("Algorithm not selected, I will try to guess it...");
                                        algName = AvailableAlgorithms.guessAlgorithms(result.getEncryptedHashes().get(0).getHash(), true);
                                        if (algName.size() == 0 || algName.size() > 1) {
                                            System.out.println("");
                                            System.out.println("ERROR! Unsupported algorithm or unknow hash!!!");
                                            System.out.println("");
                                            return;
                                        }
                                        if (algName.size() == 1) {
                                            System.out.println("Guessed algorithm to use: " + algName.get(0));
                                            algCode = AvailableAlgorithms.getAlgorithmTypeCode(algName.get(0));
                                            algorithmCode = AvailableAlgorithms.getAlgorithmCodeInput(algCode);
                                            result.setAlgorithmCodes(algorithmCode);
                                        }
                                    }
                                    break block86;
                                }
                                if (algorithmCode.length() == 1) {
                                    result.setAlgorithmCodes(algorithmCode);
                                } else {
                                    if (!JBrute.isValidChainedAlgorithmDefinition(algorithmCode)) {
                                        System.out.println("");
                                        System.out.println("ERROR! Special algorithms can not be chained : " + algorithmCode);
                                        System.out.println("");
                                        return;
                                    }
                                    result.setAlgorithmCodes(algorithmCode);
                                }
                            }
                            System.out.println("");
                            if (charsetName == null) {
                                charsetName = "loweralpha";
                                alphabet = AvailableCharsets.getCharsetByName(charsetName);
                                isDefaultCharset = true;
                            } else {
                                if (!AvailableCharsets.validateCharset(charsetName)) {
                                    System.out.println("");
                                    System.out.println("Invalid charset!");
                                    System.out.println("You have to specify one of this:");
                                    AvailableCharsets.printAvailableCharsetNames();
                                    System.out.println("");
                                    return;
                                }
                                alphabet = AvailableCharsets.getCharsetByName(charsetName);
                                System.out.println("Using " + charsetName + " as charset.");
                            }
                            processorsCount = Runtime.getRuntime().availableProcessors();
                            if (numberOfThreads > alphabet.length()) {
                                numberOfThreads = alphabet.length();
                            }
                            if (numberOfThreads == 0) {
                                numberOfThreads = 1;
                            }
                            if (numberOfThreads > processorsCount) {
                                numberOfThreads = processorsCount;
                            }
                            if (algorithmCode.length() - chainedHashCase.length() == 1) break block87;
                            if (algorithmCode.length() - chainedHashCase.length() <= 1) {
                                System.out.println("");
                                System.out.println("ERROR! Invalid length of chained hash case : " + chainedHashCase);
                                System.out.println("");
                                return;
                            }
                            System.out.println("Bad specification of case, padding with default option (lower).");
                            chainedHashCase = "";
                            i = 1;
                            if (true) ** GOTO lbl286
                        }
                        if (!JBrute.isValidChainedCase(chainedHashCase = chainedHashCase.toUpperCase())) {
                            System.out.println("");
                            System.out.println("ERROR! Invalid chained hash case : " + chainedHashCase);
                            System.out.println("");
                            return;
                        }
                        break block88;
                        do {
                            chainedHashCase = String.valueOf(chainedHashCase) + "L";
                            ++i;
lbl286:
                            // 2 sources

                        } while (i < algorithmCode.length());
                        System.out.println("Using default case for chained algorithms: " + chainedHashCase);
                    }
                    if (!decryptionMethod.equalsIgnoreCase("brute") && !decryptionMethod.equalsIgnoreCase("dictionary")) {
                        System.out.println("");
                        System.out.println("ERROR! Invalid decryption method : " + decryptionMethod);
                        System.out.println("");
                        return;
                    }
                    result.setChainedAlgorithmCase(chainedHashCase);
                    encryptionAlgorithm = AvailableAlgorithms.getAlgorithmName(algorithmCode);
                    System.out.println("Algorithm: " + encryptionAlgorithm);
                    System.out.println("Number of cores detected: " + Integer.toString(processorsCount));
                    System.out.println("Number of threads: " + numberOfThreads);
                    if (salt != null) {
                        if (preSalt) {
                            System.out.println("Pre-Salt: " + salt);
                        } else {
                            System.out.println("Post-Salt: " + salt);
                        }
                    }
                    start = System.currentTimeMillis();
                    exitCode = 1;
                    System.out.println("Number of hash/es to decrypt: " + result.getEncryptedHashes().size());
                    if (decryptionMethod.equalsIgnoreCase("brute")) {
                        System.out.println("Using brute force decryption method.");
                        if (isDefaultCharset) {
                            System.out.println("Using " + charsetName + " as charset (default).");
                        } else {
                            System.out.println("Using " + charsetName + " as charset.");
                        }
                        if (from == 0) {
                            from = 1;
                            System.out.println("Combinations of 1 characters min (default)");
                        } else {
                            System.out.println("Combinations of " + from + " characters min.");
                        }
                        if (until == 0) {
                            until = 7;
                            System.out.println("Combinations of 7 characters max (default)");
                        } else {
                            System.out.println("Combinations of " + until + " characters max.");
                        }
                        System.out.println("");
                        JBrute.decryptBruteMethod(from, until, alphabet, result, numberOfThreads);
                    } else if (decryptionMethod.equalsIgnoreCase("dictionary")) {
                        if (dictionaryFileName.equals("")) {
                            System.out.println("");
                            System.out.println("Error! You must specify a dictionary file.");
                            System.out.println("");
                            return;
                        }
                        if (!IOProcessor.fileExists(dictionaryFileName)) {
                            System.out.println("");
                            System.out.println("ERROR! Dictionary file " + dictionaryFileName + " does not exists.");
                            System.out.println("");
                            return;
                        }
                        System.out.println("Using dictionary decryption method.");
                        System.out.println("Dictionary file: " + dictionaryFileName);
                        if (stdoutMode) {
                            System.out.println("Not decrypting, just showing rules result.");
                        }
                        rules /* !! */  = new ArrayList<String>();
                        if (!rulesFileName.equals("")) {
                            if (!IOProcessor.fileExists(rulesFileName)) {
                                System.out.println("");
                                System.out.println("ERROR! Rules file " + rulesFileName + " does not exists.");
                                System.out.println("");
                                return;
                            }
                            System.out.println("Rules file: " + rulesFileName);
                            rules /* !! */  = JBrute.processDictionaryRules(rulesFileName);
                        }
                        if (stdoutMode && numberOfThreads > 1) {
                            numberOfThreads = 1;
                            System.out.println("Using 1 thread for stdout mode.");
                        }
                        JBrute.decryptDictionaryMethod(dictionaryFileName, result, numberOfThreads, rules /* !! */ , stdoutMode);
                    }
                    System.out.println("");
                    if (!result.isResolved()) break block89;
                    System.out.println("All hashes decrypted!!!");
                    System.out.println("Results: ");
                    var27_31 = result.getDecryptedHashes().iterator();
                    if (true) ** GOTO lbl373
                }
                if (result.getDecryptedHashes().size() == 0) break block90;
                System.out.println("Some hashes decrypted, but not all...");
                System.out.println("Results: ");
                var27_32 = result.getDecryptedHashes().iterator();
                if (true) ** GOTO lbl379
            }
            if (!stdoutMode) {
                System.out.println("Can not crack any password, game over...");
            }
            break block91;
            do {
                elem = var27_31.next();
                System.out.println(elem);
lbl373:
                // 2 sources

            } while (var27_31.hasNext());
            exitCode = 0;
            break block91;
            do {
                elem = var27_32.next();
                System.out.println(elem);
lbl379:
                // 2 sources

            } while (var27_32.hasNext());
        }
        System.out.println("");
        System.out.println("Total Seconds Elapsed: " + (System.currentTimeMillis() - start) / 1000L);
        System.out.println("");
        System.exit(exitCode);
    }

    private static List<String> processDictionaryRules(String rulesFileName) {
        List<String> fileLines = IOProcessor.getRulesFromRuleFile(rulesFileName);
        ArrayList<String> returnValue = new ArrayList<String>();
        for (String line : fileLines) {
            returnValue.add(line);
        }
        return returnValue;
    }

    /*
     * Unable to fully structure code
     */
    public static void mainTest(List<InParameter> optionalParameters) {
        processorsCount = Runtime.getRuntime().availableProcessors();
        numberOfThreads = 1;
        algorithmCode = "1";
        chainedHashCase = "";
        testTime = 5;
        numberOfHashes = 1;
        withSalt = false;
        for (InParameter parameter : optionalParameters) {
            block23: {
                block18: {
                    block21: {
                        block22: {
                            block19: {
                                block20: {
                                    block15: {
                                        block16: {
                                            block17: {
                                                validParameter = false;
                                                if (!parameter.getName().equalsIgnoreCase("--threads")) break block15;
                                                if (!parameter.hasValue()) break block16;
                                                if (!JBrute.isValidStringNumber(parameter.getValue())) break block17;
                                                numberOfThreads = parameter.getNumericValue();
                                                validParameter = true;
                                                break block18;
                                            }
                                            System.out.println("");
                                            System.out.println("ERROR! Invalid threads number: " + parameter.getValue());
                                            System.out.println("");
                                            return;
                                        }
                                        System.out.println("");
                                        System.err.println("ERROR! You must specify a correct thread number.");
                                        System.out.println("");
                                        return;
                                    }
                                    if (!parameter.getName().equalsIgnoreCase("--algorithm")) break block19;
                                    if (!parameter.hasValue()) break block20;
                                    algorithmCode = parameter.getValue();
                                    validParameter = true;
                                    break block18;
                                }
                                System.out.println("");
                                System.err.println("ERROR! You must specify a correct algorithm code.");
                                System.out.println("");
                                return;
                            }
                            if (!parameter.getName().equalsIgnoreCase("--chained_case")) break block21;
                            if (!parameter.hasValue()) break block22;
                            chainedHashCase = parameter.getValue();
                            validParameter = true;
                            break block18;
                        }
                        System.out.println("");
                        System.err.println("ERROR! You must specify a correct algorithm code.");
                        System.out.println("");
                        return;
                    }
                    if (!parameter.getName().equalsIgnoreCase("--time")) break block18;
                    if (!parameter.hasValue()) ** GOTO lbl59
                    if (JBrute.isValidStringNumber(parameter.getValue())) {
                        testTime = parameter.getNumericValue();
                        validParameter = true;
                    } else {
                        System.out.println("");
                        System.out.println("ERROR! Invalid time number: " + parameter.getValue());
                        System.out.println("");
                        return;
lbl59:
                        // 1 sources

                        System.out.println("");
                        System.err.println("ERROR! You must specify a correct time number (in seconds).");
                        System.out.println("");
                        return;
                    }
                }
                if (!parameter.getName().equalsIgnoreCase("--hashcount")) break block23;
                if (!parameter.hasValue()) ** GOTO lbl74
                if (JBrute.isValidStringNumber(parameter.getValue())) {
                    numberOfHashes = parameter.getNumericValue();
                    validParameter = true;
                } else {
                    System.out.println("");
                    System.out.println("ERROR! Invalid hash count number: " + parameter.getValue());
                    System.out.println("");
                    return;
lbl74:
                    // 1 sources

                    System.out.println("");
                    System.err.println("ERROR! You must specify a correct hash count number.");
                    System.out.println("");
                    return;
                }
            }
            if (parameter.getName().equalsIgnoreCase("--salt")) {
                withSalt = true;
                validParameter = true;
            }
            if (validParameter) continue;
            System.out.println("");
            System.out.println("ERROR! unknow parameter: " + parameter.toString());
            System.out.println("");
            return;
        }
        if (numberOfThreads == 0) {
            numberOfThreads = 1;
        } else if (numberOfThreads > processorsCount) {
            numberOfThreads = processorsCount;
        }
        if (!AvailableAlgorithms.isSupportedAlgorithm(algorithmCode)) {
            System.out.println("");
            System.out.println("ERROR!!! not supported algorithm.");
            System.out.println("");
            return;
        }
        if (algorithmCode.length() != 1 && !JBrute.isValidChainedAlgorithmDefinition(algorithmCode)) {
            System.out.println("");
            System.out.println("ERROR! Special algorithms can not be chained : " + algorithmCode);
            System.out.println("");
            return;
        }
        System.out.println("");
        if (algorithmCode.length() - chainedHashCase.length() == 1) ** GOTO lbl118
        if (algorithmCode.length() - chainedHashCase.length() > 1) {
            System.out.println("Bad specification of case, padding with default option (lower).");
            chainedHashCase = "";
            i = 1;
            while (i < algorithmCode.length()) {
                chainedHashCase = String.valueOf(chainedHashCase) + "L";
                ++i;
            }
            System.out.println("Using default case for chained algorithms: " + chainedHashCase);
        } else {
            System.out.println("");
            System.out.println("ERROR! Invalid length of chained hash case : " + chainedHashCase);
            System.out.println("");
            return;
lbl118:
            // 1 sources

            if (!JBrute.isValidChainedCase(chainedHashCase = chainedHashCase.toUpperCase())) {
                System.out.println("");
                System.out.println("ERROR! Invalid chained hash case : " + chainedHashCase);
                System.out.println("");
                return;
            }
        }
        System.out.println("Using " + numberOfHashes + " hash/es.");
        System.out.println("Using random salt: " + withSalt);
        JBrute.testPerformance(numberOfThreads, algorithmCode, chainedHashCase, testTime, numberOfHashes, withSalt);
    }

    /*
     * Unable to fully structure code
     */
    public static void mainEncrypt(List<InParameter> optionalParameters) {
        word = "";
        algorithmCode = "0";
        salt = "";
        chainedHashCase = "";
        saltType = "utf8";
        preSalt = false;
        upperCase = false;
        printBase64 = false;
        saltByte = null;
        for (InParameter parameter : optionalParameters) {
            if (parameter.getName().equalsIgnoreCase("--word")) {
                if (parameter.hasValue()) {
                    word = parameter.getValue();
                    continue;
                }
                System.out.println("");
                System.out.println("ERROR!!! You must specify a correct word.");
                System.out.println("");
                return;
            }
            if (parameter.getName().equalsIgnoreCase("--chained_case")) {
                if (parameter.hasValue()) {
                    chainedHashCase = parameter.getValue();
                    continue;
                }
                System.out.println("");
                System.out.println("ERROR!!! You must specify a correct chained case.");
                System.out.println("");
                return;
            }
            if (parameter.getName().equalsIgnoreCase("--algorithm")) {
                if (parameter.hasValue()) {
                    algorithmCode = parameter.getValue();
                    continue;
                }
                System.out.println("");
                System.out.println("ERROR!!! You must specify a correct algorithm code.");
                System.out.println("");
                return;
            }
            if (parameter.getName().equalsIgnoreCase("--presalt")) {
                if (parameter.hasValue()) {
                    salt = parameter.getValue();
                    preSalt = true;
                    continue;
                }
                System.out.println("");
                System.out.println("ERROR!!! You must specify a correct presalt.");
                System.out.println("");
                return;
            }
            if (parameter.getName().equalsIgnoreCase("--postsalt")) {
                if (parameter.hasValue()) {
                    salt = parameter.getValue();
                    preSalt = false;
                    continue;
                }
                System.out.println("");
                System.out.println("ERROR!!! You must specify a correct postsalt.");
                System.out.println("");
                return;
            }
            if (parameter.getName().equalsIgnoreCase("--salt_type")) {
                if (parameter.hasValue()) {
                    myAux = parameter.getValue();
                    if (myAux.equalsIgnoreCase("int64")) {
                        saltType = myAux;
                        continue;
                    }
                    if (myAux.equalsIgnoreCase("hex")) {
                        saltType = myAux;
                        continue;
                    }
                    if (myAux.equalsIgnoreCase("utf8")) {
                        saltType = myAux;
                        continue;
                    }
                    System.out.println("");
                    System.err.println("ERROR! You must specify a correct salt type.");
                    System.out.println("");
                    return;
                }
                System.out.println("");
                System.err.println("ERROR! You must specify a correct salt type.");
                System.out.println("");
                return;
            }
            if (parameter.getName().equalsIgnoreCase("--upper")) {
                upperCase = true;
                continue;
            }
            if (parameter.getName().equalsIgnoreCase("--base64")) {
                printBase64 = true;
                continue;
            }
            System.out.println("");
            System.out.println("ERROR!!! unknow parameter: " + parameter.getName());
            System.out.println("");
            return;
        }
        if (!AvailableAlgorithms.isSupportedAlgorithm(algorithmCode)) {
            System.out.println("");
            System.out.println("ERROR! Unsupported algorithm!!!");
            System.out.println("");
            return;
        }
        if (algorithmCode.length() != 1 && !JBrute.isValidChainedAlgorithmDefinition(algorithmCode)) {
            System.out.println("");
            System.out.println("ERROR! Special algorithms can not be chained : " + algorithmCode);
            System.out.println("");
            return;
        }
        if (algorithmCode.length() - chainedHashCase.length() == 1) ** GOTO lbl108
        if (algorithmCode.length() - chainedHashCase.length() > 1) {
            System.out.println("Bad specification of case, padding with default option (lower).");
            chainedHashCase = "";
            i = 1;
            while (i < algorithmCode.length()) {
                chainedHashCase = String.valueOf(chainedHashCase) + "L";
                ++i;
            }
            System.out.println("Using default case for chained algorithms: " + chainedHashCase);
        } else {
            System.out.println("");
            System.out.println("ERROR! Invalid length of chained hash case : " + chainedHashCase);
            System.out.println("");
            return;
lbl108:
            // 1 sources

            if (!JBrute.isValidChainedCase(chainedHashCase = chainedHashCase.toUpperCase())) {
                System.out.println("");
                System.out.println("ERROR! Invalid chained hash case : " + chainedHashCase);
                System.out.println("");
                return;
            }
        }
        System.out.println("");
        if (word.equals("")) {
            System.out.println("ERROR! You must specify a word!!!");
        } else {
            if (!salt.equals("") && (saltByte = AvailableAlgorithms.getSaltByteArray(salt, saltType)) == null) {
                System.out.println("");
                System.out.println("ERROR! Invalid salt type value " + salt + " for salt type " + saltType);
                System.out.println("");
                return;
            }
            JBrute.encryptPlaintext(word, algorithmCode, chainedHashCase, salt, saltByte, saltType, preSalt, upperCase, printBase64);
        }
        System.out.println("");
    }

    public static void mainOptimalThreads() {
        int processorsCount = Runtime.getRuntime().availableProcessors();
        System.out.println("");
        System.out.println("Number of cores detected: " + Integer.toString(processorsCount));
        System.out.println("Testing performance for MD5 for 1 thread to " + processorsCount + " threads...");
        int acum = 0;
        int bestThreadsNumber = 0;
        long start = System.currentTimeMillis();
        ArrayList<MyBruteDecryptThread> listaThreads = new ArrayList<MyBruteDecryptThread>();
        ProcessResult pr = new ProcessResult();
        int j = 1;
        while (j <= processorsCount) {
            int numberOfThreads = j;
            System.out.print("Estimating performance for " + numberOfThreads + " thread/s...");
            pr.setAlgorithmCodes("1");
            int i = 1;
            while (i <= numberOfThreads) {
                listaThreads.add(new MyBruteDecryptThread(true, pr, 1, false));
                ++i;
            }
            for (MyBruteDecryptThread thread : listaThreads) {
                thread.start();
            }
            for (MyBruteDecryptThread thread : listaThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println(" " + pr.getTryesCount() / 10 + " hashes per second.");
            if (acum <= pr.getTryesCount() / 10) {
                acum = pr.getTryesCount() / 10;
                bestThreadsNumber = numberOfThreads;
            }
            listaThreads.clear();
            pr.setTestCount(0);
            ++j;
        }
        System.out.println("");
        System.out.println("Best threads number: " + bestThreadsNumber);
        System.out.println("You could compute " + acum + " MD5 hashes/sec approx.");
        System.out.println("");
        int segundosProcesamiento = (int)(System.currentTimeMillis() - start) / 1000;
        if (segundosProcesamiento == 0) {
            segundosProcesamiento = 1;
        }
        System.out.println("Total time elapsed: " + segundosProcesamiento + " seconds.");
        System.out.println("");
    }

    public static void mainHelp() {
        System.out.println("");
        System.out.println("Available parameters:");
        System.out.println("\t--decrypt: decrypt a hash.");
        System.out.println("\t\t--algorithm=<CODE>: specify the code of the algoritm to use (multiple codes accepted).");
        System.out.println("\t\t\tAvailable codes:");
        System.out.println("\t\t\t\t1: MD5");
        System.out.println("\t\t\t\t2: MD4");
        System.out.println("\t\t\t\t5: SHA-256");
        System.out.println("\t\t\t\t6: SHA-512");
        System.out.println("\t\t\t\t8: MD5CRYPT");
        System.out.println("\t\t\t\t9: SHA-1");
        System.out.println("\t\t\t\tA: ORACLE-10G");
        System.out.println("\t\t\t\tB: ORACLE-11G");
        System.out.println("\t\t\t\tC: NTLM");
        System.out.println("\t\t\t\tD: LM");
        System.out.println("\t\t\t\tE: MSSQL-2000");
        System.out.println("\t\t\t\tF: MSSQL-2005");
        System.out.println("\t\t\t\tG: MSSQL-2012");
        System.out.println("\t\t\t\tH: MYSQL-322");
        System.out.println("\t\t\t\tI: MYSQL-411");
        System.out.println("\t\t\t\tJ: POSTGRESQL");
        System.out.println("\t\t\t\tK: SYBASE-ASE1502");
        System.out.println("\t\t\t\tL: INFORMIX-1170");
        System.out.println("\t\t\t\t            ");
        System.out.println("\t\t   Multiple codes accepted: combinations of codes 1, 2, 5, 6, 9.");
        System.out.println("\t\t--chained_case=<STRING>: binary, lower case or upper case for chained hashing (multiple values accepted)");
        System.out.println("\t\t\taccepted values: [R|L|U] (Raw, Lower or Upper, default L)");
        System.out.println("\t\t--charset=<CHARSET_NAME>: specify an available charset (default loweralpha)");
        System.out.println("\t\t--dict_file=<FILE_NAME>: specify the file name of the dictionary to use with --method=dictionary (default wordlist.txt)");
        System.out.println("\t\t--hash or --hash_file=<FILE_NAME>: specify one hash or the name of a file containing hashes.");
        System.out.println("\t\t--maxlength=<NUMBER>: max password length (default 7)");
        System.out.println("\t\t--method=<STRING>: 'brute' or 'dictionary' (default brute)");
        System.out.println("\t\t--minlength=<NUMBER>: min password length (default 1)");
        System.out.println("\t\t--postsalt=<STRING>: specify a post-salt to use only for no-special algorithms (default empty)");
        System.out.println("\t\t--presalt=<STRING>: specify a pre-salt to use only for no-special algorithms (default empty)");
        System.out.println("\t\t--rule_file=<FILE_NAME>: specify the file name of the rule's file to use with --method=dictionary (default rules.txt)");
        System.out.println("\t\t\tAvailable rules: similar to in John the Ripper (masking partially supported).");
        System.out.println("\t\t--salt_type=<STRING>: specify salt type.");
        System.out.println("\t\t\taccepted values: [hex|int64|utf8] (default utf8)");
        System.out.println("\t\t--stdout: show rules application for --method=dictionary (default false)");
        System.out.println("\t\t--threads=<NUMBER>: number of threads to use (default 1)");
        System.out.println("\t--encrypt: encrypt a word.");
        System.out.println("\t\t--algorithm=<CODE>: specify the code of the algoritm to use (multiple codes accepted, default 1).");
        System.out.println("\t\t\tAvailable codes: same ones as --decrypt --algorithm option.");
        System.out.println("\t\t--base64: specify the final hash in base64 too.");
        System.out.println("\t\t--chained_case=<STRING>: binary, lower case or upper case for chained hashing (multiple values accepted)");
        System.out.println("\t\t\taccepted values: [R|L|U] (Raw, Lower or Upper, default L)");
        System.out.println("\t\t--presalt=<STRING>: specify a pre-salt to use only for no-special algorithms (default empty)");
        System.out.println("\t\t--postsalt=<STRING>: specify a post-salt to use only for no-special algorithms (default empty)");
        System.out.println("\t\t--salt_type=<STRING>: specify salt type.");
        System.out.println("\t\t\taccepted values: [hex|int64|utf8] (default utf8)");
        System.out.println("\t\t--upper: specify the final hash in uppercase.");
        System.out.println("\t\t--word=<STRING>: specify a word to encrypt");
        System.out.println("\t--expected: print hash example for each supported algorithm.");
        System.out.println("\t--guess: try to identify the algorithm of a hash (can return multiple algorithms).");
        System.out.println("\t\t--hash=<HASH> or --hash_file=<FILE_NAME>: specify one hash or the name of a file containing hashes.");
        System.out.println("\t\t--lucky: determinate the most probably algorithm for the hash (just one).");
        System.out.println("\t--list_charsets: print available charsets.");
        System.out.println("\t--test: estimate number of hashes that you could process with your actual hardware.");
        System.out.println("\t\t--algorithm=<CODE>: specify the code of the algoritm to use (multiple codes accepted, default 1).");
        System.out.println("\t\t\tAvailable codes: same ones as --decrypt --algorithm option.");
        System.out.println("\t\t--chained_case=<STRING>: binary, lower case or upper case for chained hashing (multiple values accepted)");
        System.out.println("\t\t\taccepted values: [R|L|U] (Raw, Lower or Upper, default L)");
        System.out.println("\t\t--hashcount=<NUMBER>: number of hashes to use (default 1)");
        System.out.println("\t\t--time=<NUMBER>: number of seconds to use (default 5)");
        System.out.println("\t\t--threads=<NUMBER>: number of threads to use (default 1)");
        System.out.println("\t\t--salt: use a random salt for each hash (default false)");
        System.out.println("\t--version: print current version");
        System.out.println("");
    }

    public static void mainListCharsets() {
        AvailableCharsets.printAvailableCharsetContents();
    }

    public static void mainVersion() {
        System.out.println("");
        System.out.println("Current Version : 0.99 (beta)");
        System.out.println("Supported JRE   : 1.7.0_21+");
        System.out.println("Release Date    : 09/11/2013");
        System.out.println("Autor           : Gonzalo L. Camino (gonzalocamino@gmail.com)");
        System.out.println("");
    }

    /*
     * Unable to fully structure code
     */
    private static void encryptPlaintext(String plaintext, String algorithmCodes, String chainedAlgorithmCase, String salt, byte[] saltByte, String saltType, boolean preSalt, boolean upperCase, boolean printBase64) {
        block14: {
            block15: {
                block13: {
                    resultSalt = bword = plaintext.getBytes();
                    System.out.println("Word to hash: " + plaintext);
                    finalHash = "";
                    algorithmName = AvailableAlgorithms.getAlgorithmName(algorithmCodes);
                    if (!AvailableAlgorithms.isNativeAlgorithm(algorithmCodes)) break block13;
                    if (saltByte != null) {
                        if (preSalt) {
                            resultSalt = ByteArray.concat(saltByte, bword);
                            System.out.println("Pre-salt used: " + salt);
                        } else {
                            resultSalt = ByteArray.concat(bword, saltByte);
                            System.out.println("Post-salt used: " + salt);
                        }
                        System.out.println("Salt type: " + saltType);
                    }
                    ma = AvailableAlgorithms.getMessageDigestArray(algorithmCodes);
                    chainedAlgorithmCase = new StringBuilder(chainedAlgorithmCase.toUpperCase()).reverse().toString();
                    anError = false;
                    i = 0;
                    while (i < ma.length) {
                        if (ma[i] == null) {
                            anError = true;
                        }
                        ++i;
                    }
                    if (ma == null || anError) {
                        System.out.println("");
                        System.out.println("ERROR! Algorithm not supported here.");
                        System.out.println("");
                        return;
                    }
                    aux = null;
                    i = 0;
                    while (i < ma.length) {
                        ma[i].update(resultSalt, 0, resultSalt.length);
                        aux = ma[i].digest();
                        if (ma.length - 1 != i) {
                            resultSalt = AuxiliaryForDecryptThreads.getIntermediateChainedHash(aux, chainedAlgorithmCase, i);
                        }
                        ++i;
                    }
                    finalHash = AvailableAlgorithms.getLowerCaseHash(aux);
                    if (!chainedAlgorithmCase.equalsIgnoreCase("")) {
                        System.out.println("Chained case: " + chainedAlgorithmCase);
                    }
                    break block14;
                }
                if (algorithmCodes.length() != 1) break block14;
                algorithmCode = AvailableAlgorithms.getAlgorithmCodeFromInput(algorithmCodes);
                m = AvailableAlgorithms.getMyMessageDigest(algorithmCode);
                if (m != null) break block15;
                System.out.println("");
                System.out.println("ERROR! Invalid special algorithm!!!");
                System.out.println("");
                break block14;
            }
            if (!AvailableAlgorithms.isUsernameSaltedHash(algorithmCode)) ** GOTO lbl60
            if (!saltByte.equals("")) {
                System.out.println("Username (salt) used: " + salt);
                finalHash = m.crypt(plaintext, salt);
            } else {
                System.err.println("");
                System.err.println("ERROR! Algorithm " + algorithmName + " is user-salted. You must specify a salt (pre or post is the same).");
                System.err.println("");
                return;
lbl60:
                // 1 sources

                finalHash = m.crypt(plaintext, null);
            }
        }
        if (upperCase) {
            finalHash = finalHash.toUpperCase();
        }
        System.out.println("Hash " + algorithmName + " : " + finalHash);
        finalHash2 = "";
        if (printBase64) {
            aux = DatatypeConverter.parseHexBinary((String)finalHash);
            finalHash2 = DatatypeConverter.printBase64Binary((byte[])aux);
            System.out.println("Base64 " + algorithmName + " : " + finalHash2);
        }
    }

    private static String encryptWord(String word, int algorithmCode, String auxSalt) {
        String resultHash;
        byte[] bword = word.getBytes();
        byte[] result = null;
        if (AvailableAlgorithms.isNativeAlgorithm(algorithmCode)) {
            MessageDigest m = AvailableAlgorithms.getMessageDigest(algorithmCode);
            m.update(bword);
            result = m.digest();
            resultHash = DatatypeConverter.printHexBinary((byte[])result);
        } else {
            MyMessageDigest m = AvailableAlgorithms.getMyMessageDigest(algorithmCode);
            if (!AvailableAlgorithms.isUsernameSaltedHash(algorithmCode)) {
                auxSalt = null;
            }
            resultHash = m.crypt(word, auxSalt);
        }
        return resultHash;
    }

    private static StringBuilder nextCombinationCustom(String alphabet, StringBuilder input) {
        StringBuilder returnValue = new StringBuilder();
        int inputLength = input.length();
        int alphabetLength = alphabet.length();
        char c = input.charAt(inputLength - 1);
        char nextChar = '\u0000';
        if (c == alphabet.charAt(alphabetLength - 1)) {
            char firstAlphabetCharacter = alphabet.charAt(0);
            if (inputLength == 1) {
                returnValue = new StringBuilder();
                returnValue.append(firstAlphabetCharacter);
                returnValue.append(firstAlphabetCharacter);
            } else {
                input.deleteCharAt(inputLength - 1);
                returnValue = JBrute.nextCombinationCustom(alphabet, input).append(firstAlphabetCharacter);
            }
        } else {
            int i = 0;
            while (i < alphabetLength) {
                if (alphabet.charAt(i) == c) {
                    nextChar = alphabet.charAt(i + 1);
                    break;
                }
                ++i;
            }
            input.setCharAt(inputLength - 1, nextChar);
            returnValue = input;
        }
        return returnValue;
    }

    private static void decryptBruteMethod(int longDesde, int longHasta, String alphabet, ProcessResult pr, int numberOfThreads) {
        StringBuilder firstCombination = new StringBuilder("");
        StringBuilder lastCombination = new StringBuilder("");
        long start = System.currentTimeMillis();
        ArrayList<JBruteThread> myThreads = new ArrayList<JBruteThread>();
        pr.validateEncryptedHashes();
        if (pr.getPendingEncryptedHashes().size() == 0) {
            System.err.println();
            System.err.println("There are no valid hashes to decrypt!!!");
            System.err.println();
            return;
        }
        int i = longDesde;
        while (i <= longHasta) {
            List<StringBuilder> allWords = JBrute.generateAllWords(alphabet, i, numberOfThreads);
            System.out.println("Starting with combinations of " + Integer.toString(i) + " characters...");
            int j = 0;
            while (j < numberOfThreads) {
                firstCombination = j == 0 ? allWords.get(j) : JBrute.nextCombinationCustom(alphabet, allWords.get(j));
                lastCombination = allWords.get(j + 1);
                myThreads.add(new MyBruteDecryptThread("Thread " + j, alphabet, firstCombination.toString(), lastCombination.toString(), pr));
                ++j;
            }
            pr.setThreads(myThreads);
            for (JBruteThread thread : myThreads) {
                thread.setPriority(10);
                thread.start();
            }
            for (JBruteThread thread : myThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            myThreads.clear();
            if (pr.isResolved()) {
                System.out.println("");
                break;
            }
            System.out.println("Done. (Time elapsed (sec): " + (System.currentTimeMillis() - start) / 1000L + ")");
            ++i;
        }
    }

    private static void decryptDictionaryMethod(String dictionaryFileName, ProcessResult pr, int numberOfThreads, List<String> ruleLines, boolean stdoutMode) {
        pr.validateEncryptedHashes();
        if (pr.getPendingEncryptedHashes().size() == 0 && !stdoutMode) {
            System.err.println();
            System.err.println("There are no valid hashes to decrypt!!!");
            System.err.println();
            return;
        }
        System.out.print("Reading words from dictionary... ");
        List<StringBuilder> words = IOProcessor.getStringBuilderLinesFromFile(dictionaryFileName);
        List<WordList> threadWords = JBrute.getWordsForEachThread(words, numberOfThreads);
        System.out.println(String.valueOf(words.size()) + " words readed.");
        ArrayList<JBruteThread> myThreads = new ArrayList<JBruteThread>();
        boolean printRulesLoaded = true;
        int i = 0;
        while (i < numberOfThreads) {
            List<DictionaryRule> rules = DictionaryRulePreProcessor.getInstance().getRulesFromRuleLines(ruleLines, printRulesLoaded);
            MyDictionaryDecryptThread myThread = new MyDictionaryDecryptThread("Thread " + i, pr, threadWords.get(i).getList(), rules, stdoutMode);
            printRulesLoaded = false;
            myThread.setPriority(10);
            myThreads.add(myThread);
            pr.setThreads(myThreads);
            ++i;
        }
        System.out.println("");
        System.out.println("Starting decryption process (method: dictionary)");
        long start = System.currentTimeMillis();
        for (JBruteThread thread : myThreads) {
            thread.setPriority(10);
            thread.start();
        }
        for (JBruteThread thread : myThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        long totalSeconds = (System.currentTimeMillis() - start) / 1000L;
        System.out.println("Decryption process finished (seconds elapsed: " + totalSeconds + ")");
        myThreads.clear();
        if (pr.isResolved() && !stdoutMode) {
            System.out.println("");
        }
    }

    private static List<WordList> getWordsForEachThread(List<StringBuilder> words, int numberOfThreads) {
        int numberOfWords = words.size() / numberOfThreads;
        ArrayList<WordList> returnValue = new ArrayList<WordList>();
        int start = 0;
        int end = numberOfWords;
        int i = 0;
        while (i < numberOfThreads) {
            WordList aux = new WordList();
            int j = start;
            while (j < end) {
                aux.addWord(words.get(j));
                ++j;
            }
            returnValue.add(aux);
            start = end;
            if (words.size() - (end += numberOfWords) < numberOfWords) {
                end = words.size();
            }
            ++i;
        }
        return returnValue;
    }

    private static List<StringBuilder> generateAllWords(String alphabet, int i, int numberOfThreads) {
        ArrayList<StringBuilder> words = new ArrayList<StringBuilder>();
        StringBuilder aux = new StringBuilder("");
        aux.append(alphabet.charAt(0));
        aux = JBrute.fillWithFirstCharOfAlphabet(alphabet, aux, i);
        words.add(aux);
        if (numberOfThreads > 1) {
            int j = 1;
            while (j < numberOfThreads) {
                aux = new StringBuilder("");
                aux.append(alphabet.charAt(alphabet.length() / numberOfThreads * j - 1));
                aux = JBrute.fillWithLastCharOfAlphabet(alphabet, aux, i);
                words.add(aux);
                ++j;
            }
        }
        aux = new StringBuilder("");
        aux.append(alphabet.charAt(alphabet.length() - 1));
        aux = JBrute.fillWithLastCharOfAlphabet(alphabet, aux, i);
        words.add(aux);
        return words;
    }

    private static StringBuilder fillWithFirstCharOfAlphabet(String alphabet, StringBuilder sb, int i) {
        StringBuilder returnValue = new StringBuilder("");
        returnValue.append(sb.toString());
        int j = 1;
        while (j < i) {
            returnValue.append(alphabet.charAt(0));
            ++j;
        }
        return returnValue;
    }

    private static StringBuilder fillWithLastCharOfAlphabet(String alphabet, StringBuilder sb, int i) {
        StringBuilder returnValue = new StringBuilder("");
        returnValue.append(sb.toString());
        int j = 1;
        while (j < i) {
            returnValue.append(alphabet.charAt(alphabet.length() - 1));
            ++j;
        }
        return returnValue;
    }

    private static void testPerformance(int numberOfThreads, String algorithmCode, String chainedHashCase, int testTime, int numberOfHashes, boolean withSalt) {
        int processorsCount = Runtime.getRuntime().availableProcessors();
        System.out.println("Number of cores detected: " + Integer.toString(processorsCount));
        System.out.println("Number of threads to use: " + numberOfThreads);
        System.out.println("");
        ProcessResult pr = new ProcessResult();
        pr.setAlgorithmCodes(algorithmCode);
        pr.setChainedAlgorithmCase(chainedHashCase);
        pr.setTestTime(testTime);
        ArrayList<MyBruteDecryptThread> listaThreads = new ArrayList<MyBruteDecryptThread>();
        String algorithmName = AvailableAlgorithms.getAlgorithmName(algorithmCode);
        System.out.println("Benchmarking " + algorithmName + " ...");
        int i = 0;
        while (i < numberOfThreads) {
            listaThreads.add(new MyBruteDecryptThread(true, pr, numberOfHashes, withSalt));
            ++i;
        }
        for (MyBruteDecryptThread thread : listaThreads) {
            thread.start();
        }
        for (MyBruteDecryptThread thread : listaThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        listaThreads.clear();
        System.out.println("You could compute " + pr.getTestResult() + " " + algorithmName + " words/sec approx.");
        pr.setTestCount(0);
        System.out.println("");
    }

    private static boolean isValidStringNumber(String number) {
        boolean returnValue = true;
        int i = 0;
        while (i < number.length()) {
            if (!Character.isDigit(number.charAt(i))) {
                returnValue = false;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    private static boolean isValidWordLengthNumber(String number) {
        return JBrute.isValidStringNumber(number);
    }

    private static boolean isValidChainedCase(String value) {
        boolean returnValue = true;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c != 'L' && c != 'U' && c != 'R') {
                returnValue = false;
                break;
            }
            ++i;
        }
        return returnValue;
    }

    private static boolean isValidChainedAlgorithmDefinition(String algorithmCodes) {
        boolean returnValue = true;
        String algorithm = "";
        int i = 0;
        while (i < algorithmCodes.length()) {
            char c = algorithmCodes.charAt(i);
            int algorithmCode = AvailableAlgorithms.getAlgorithmCodeFromInput(algorithm = String.valueOf(algorithm) + c);
            if (AvailableAlgorithms.isHashedSpecialAlgorithm(algorithmCode)) {
                returnValue = false;
                break;
            }
            algorithm = "";
            ++i;
        }
        return returnValue;
    }
}

