/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

public class TableItem
extends Item {
    Table parent;
    Font font;
    Font[] cellFont;
    String[] strings;
    boolean cached;
    boolean grayed;
    boolean settingData;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount(), true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        if (create) {
            parent.createItem(this, index);
        } else {
            this.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_iter_nth_child(parent.modelHandle, this.handle, 0L, index);
        }
    }

    static Table checkNull(Table control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    Color _getBackground() {
        long[] ptr = new long[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 3, ptr, -1);
        if (ptr[0] == 0L) {
            return this.parent.getBackground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, ptr[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(ptr[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    Color _getBackground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this._getBackground();
        }
        long[] ptr = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 3, ptr, -1);
        if (ptr[0] == 0L) {
            return this._getBackground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, ptr[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(ptr[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    boolean _getChecked() {
        int[] ptr = new int[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 0, ptr, -1);
        return ptr[0] != 0;
    }

    Color _getForeground() {
        long[] ptr = new long[1];
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, 2, ptr, -1);
        if (ptr[0] == 0L) {
            return this.parent.getForeground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, ptr[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(ptr[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    Color _getForeground(int index) {
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this._getForeground();
        }
        long[] ptr = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 2, ptr, -1);
        if (ptr[0] == 0L) {
            return this._getForeground();
        }
        GdkRGBA gdkRGBA = new GdkRGBA();
        OS.memmove(gdkRGBA, ptr[0], (long)GdkRGBA.sizeof);
        GDK.gdk_rgba_free(ptr[0]);
        return Color.gtk_new(this.display, gdkRGBA);
    }

    Image _getImage(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return null;
        }
        long[] surfaceHandle = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 5, surfaceHandle, -1);
        if (surfaceHandle[0] == 0L) {
            return null;
        }
        int imageIndex = this.parent.imageList.indexOf(surfaceHandle[0]);
        if (imageIndex == -1) {
            return null;
        }
        return this.parent.imageList.get(imageIndex);
    }

    String _getText(int index) {
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return "";
        }
        long[] ptr = new long[1];
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GTK.gtk_tree_model_get(this.parent.modelHandle, this.handle, modelIndex + 1, ptr, -1);
        if (ptr[0] == 0L) {
            return "";
        }
        int length = C.strlen(ptr[0]);
        byte[] buffer = new byte[length];
        C.memmove(buffer, ptr[0], (long)length);
        OS.g_free(ptr[0]);
        return new String(Converter.mbcsToWcs(buffer));
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        if (this.parent.currentItem == this) {
            return;
        }
        if (this.cached || (this.parent.style & 0x10000000) == 0) {
            int columnCount = GTK.gtk_tree_model_get_n_columns(this.parent.modelHandle);
            int i = 0;
            while (i < 2) {
                GTK.gtk_list_store_set(this.parent.modelHandle, this.handle, i, 0, -1);
                ++i;
            }
            i = 2;
            while (i < columnCount) {
                GTK.gtk_list_store_set(this.parent.modelHandle, this.handle, i, 0L, -1);
                ++i;
            }
        }
        this.cached = false;
        this.font = null;
        this.cellFont = null;
        this.strings = null;
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    public void dispose() {
        Widget tmpParent = null;
        if (this.parent != null && this.parent.getItemCount() > 0 && this.parent.getSelectionCount() == 0) {
            tmpParent = this.parent;
        }
        super.dispose();
        if (tmpParent != null && !tmpParent.isDisposed()) {
            ((Table)tmpParent).deselectAll();
        }
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getBackground(index);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this._getChecked();
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.columnCount);
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[index] == null) {
            return this.getFont();
        }
        return this.cellFont[index];
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getForeground(index);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this._getImage(index);
    }

    @Override
    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    @Override
    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.strings != null && index >= 0 && index < this.strings.length) {
            String string = this.strings[index];
            return string != null ? string : "";
        }
        return this._getText(index);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0L) {
            OS.g_free(this.handle);
        }
        this.handle = 0L;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.font = null;
        this.cellFont = null;
        this.strings = null;
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this._getChecked() == checked) {
            return;
        }
        GTK.gtk_list_store_set(this.parent.modelHandle, this.handle, 0, checked, -1);
        GTK.gtk_list_store_set(this.parent.modelHandle, this.handle, 1, !checked ? false : this.grayed, -1);
        this.cached = true;
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if (image != null && image.type == 1 && image.equals(this._getImage(index))) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        long pixbuf = 0L;
        long surface = 0L;
        if (image != null) {
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            int imageIndex = imageList.indexOf(image);
            long tempSurface = ImageList.convertSurface(image);
            Cairo.cairo_surface_destroy(tempSurface);
            if (imageIndex == -1) {
                imageIndex = imageList.add(image);
            }
            surface = imageList.getSurface(imageIndex);
            pixbuf = ImageList.createPixbuf(surface);
        }
        long parentHandle = this.parent.handle;
        long column = GTK.gtk_tree_view_get_column(parentHandle, index);
        long pixbufRenderer = this.parent.getPixbufRenderer(column);
        int[] currentWidth = new int[1];
        int[] currentHeight = new int[1];
        GTK.gtk_cell_renderer_get_fixed_size(pixbufRenderer, currentWidth, currentHeight);
        if (!this.parent.pixbufSizeSet) {
            if (image != null) {
                int iHeight;
                int iWidth;
                if (DPIUtil.useCairoAutoScale()) {
                    iWidth = image.getBounds().width;
                    iHeight = image.getBounds().height;
                } else {
                    iWidth = image.getBoundsInPixels().width;
                    iHeight = image.getBoundsInPixels().height;
                }
                if (iWidth > currentWidth[0] || iHeight > currentHeight[0]) {
                    GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, iWidth, iHeight);
                    this.parent.pixbufHeight = iHeight;
                    this.parent.pixbufWidth = iWidth;
                    this.parent.pixbufSizeSet = true;
                }
            }
        } else if (this.parent.pixbufWidth > Math.max(currentWidth[0], 0) || this.parent.pixbufHeight > Math.max(currentHeight[0], 0)) {
            GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, this.parent.pixbufWidth, this.parent.pixbufHeight);
        }
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GTK.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 0, pixbuf, -1);
        if (pixbuf != 0L) {
            OS.g_object_unref(pixbuf);
        }
        GTK.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 5, surface, -1);
        this.cached = true;
        if (this.parent.columnCount == 0) {
            column = GTK.gtk_tree_view_get_column(this.parent.handle, index);
            this.parent.maxWidth = Math.max(this.parent.maxWidth, this.parent.calculateWidth(column, this.handle));
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.strings == null ? this._getText(index).equals(string) : this.getText(index).equals(string)) {
            return;
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (index >= 0 && index < count) {
            if (this.strings == null) {
                this.strings = new String[count];
            }
            if (string.equals(this.strings[index])) {
                return;
            }
            this.strings[index] = string;
        }
        if (string != null && string.length() > 8192) {
            string = String.valueOf(string.substring(0, 8192 - "...".length())) + "...";
        }
        byte[] buffer = Converter.wcsToMbcs(string, true);
        int modelIndex = this.parent.columnCount == 0 ? 5 : this.parent.columns[index].modelIndex;
        GTK.gtk_list_store_set(this.parent.modelHandle, this.handle, modelIndex + 1, buffer, -1);
        this.cached = true;
        if (this.parent.columnCount == 0) {
            long column = GTK.gtk_tree_view_get_column(this.parent.handle, index);
            this.parent.maxWidth = Math.max(this.parent.maxWidth, this.parent.calculateWidth(column, this.handle));
        }
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }
}

