/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        if (GTK.GTK_VERSION < OS.VERSION(3, 22, 0)) {
            long window = this.parent.paintWindow();
            long cairo = GDK.gdk_cairo_create(window);
            if (cairo == 0L) {
                this.error(2);
            }
            Cairo.cairo_set_source_rgba(cairo, 1.0, 1.0, 1.0, 1.0);
            Cairo.cairo_set_operator(cairo, 23);
            if (this.image != null && !this.image.isDisposed() && this.image.mask == 0L) {
                long surface = Cairo.cairo_get_target(cairo);
                int nWidth = 0;
                switch (Cairo.cairo_surface_get_type(surface)) {
                    case 0: {
                        nWidth = Cairo.cairo_image_surface_get_width(surface);
                        break;
                    }
                    case 3: {
                        nWidth = Cairo.cairo_xlib_surface_get_width(surface);
                    }
                }
                int nX = this.x;
                if ((this.parent.style & 0x8000000) != 0) {
                    nX = this.parent.getClientWidth() - nWidth - nX;
                }
                Cairo.cairo_translate(cairo, nX, this.y);
                Cairo.cairo_set_source_surface(cairo, this.image.surface, 0.0, 0.0);
                Cairo.cairo_paint(cairo);
            } else {
                int nWidth = this.width;
                int nHeight = this.height;
                if (nWidth <= 0) {
                    nWidth = 1;
                }
                int nX = this.x;
                if ((this.parent.style & 0x8000000) != 0) {
                    nX = this.parent.getClientWidth() - nWidth - nX;
                }
                Cairo.cairo_rectangle(cairo, nX, this.y, nWidth, nHeight);
            }
            Cairo.cairo_fill(cairo);
            Cairo.cairo_destroy(cairo);
            return true;
        }
        GTK.gtk_widget_queue_draw(this.parent.handle);
        return true;
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent != null && this == this.parent.caret) {
            if (!this.parent.isDisposed()) {
                this.parent.setCaret(null);
            } else {
                this.parent.caret = null;
            }
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

