/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.Serializable;
import org.eclipse.swt.SWT;

public final class Rectangle
implements Serializable {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void add(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        int left = this.x < rect.x ? this.x : rect.x;
        int top = this.y < rect.y ? this.y : rect.y;
        int lhs = this.x + this.width;
        int rhs = rect.x + rect.width;
        int right = lhs > rhs ? lhs : rhs;
        lhs = this.y + this.height;
        rhs = rect.y + rect.height;
        int bottom = lhs > rhs ? lhs : rhs;
        this.x = left;
        this.y = top;
        this.width = right - left;
        this.height = bottom - top;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Rectangle)) {
            return false;
        }
        Rectangle r = (Rectangle)object;
        return r.x == this.x && r.y == this.y && r.width == this.width && r.height == this.height;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.width ^ this.height;
    }

    public boolean intersects(int x, int y, int width, int height) {
        return x < this.x + this.width && y < this.y + this.height && x + width > this.x && y + height > this.y;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return rect == this || this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public String toString() {
        return "Rectangle {" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "}";
    }
}

