/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ClipboardProxy;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static long GTKCLIPBOARD = GTK.GTK4 ? GDK.gdk_display_get_clipboard(GDK.gdk_display_get_default()) : GTK3.gtk_clipboard_get(0L);
    static long GTKPRIMARYCLIPBOARD;
    private static long TARGET;

    static {
        byte[] buffer = Converter.wcsToMbcs("PRIMARY", true);
        long primary = GDK.gdk_atom_intern(buffer, false);
        GTKPRIMARYCLIPBOARD = GTK.GTK4 ? GDK.gdk_display_get_primary_clipboard(GDK.gdk_display_get_default()) : GTK3.gtk_clipboard_get(primary);
        buffer = Converter.wcsToMbcs("TARGETS", true);
        TARGET = GDK.gdk_atom_intern(buffer, false);
    }

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = Clipboard.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length == 0) {
            DND.error(5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !dataTypes[i].validate(data[i])) {
                DND.error(5);
            }
            ++i;
        }
        ClipboardProxy proxy = ClipboardProxy._getInstance(this.display);
        if (!proxy.setData(this, data, dataTypes, clipboards)) {
            DND.error(2002);
        }
    }
}

