/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui.actions;

import net.azib.ipscan.config.FavoritesConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.UserErrorException;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.gui.EditFavoritesDialog;
import net.azib.ipscan.gui.InputDialog;
import net.azib.ipscan.gui.actions.StartStopScanningAction;
import net.azib.ipscan.gui.feeders.FeederGUIRegistry;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class FavoritesMenuActions {

    public static final class ShowMenu
    implements Listener {
        private final SelectionListener favoritesSelectListener;
        private final FavoritesConfig favoritesConfig;
        private final StateMachine stateMachine;

        public ShowMenu(FavoritesConfig favoritesConfig, Select favoritesSelectListener, StateMachine stateMachine) {
            this.favoritesConfig = favoritesConfig;
            this.favoritesSelectListener = favoritesSelectListener;
            this.stateMachine = stateMachine;
        }

        @Override
        public void handleEvent(Event event) {
            Menu favoritesMenu = (Menu)event.widget;
            MenuItem[] menuItems = favoritesMenu.getItems();
            for (int i = 3; i < menuItems.length; ++i) {
                menuItems[i].dispose();
            }
            for (String name : this.favoritesConfig) {
                MenuItem menuItem = new MenuItem(favoritesMenu, 64);
                menuItem.setText(name);
                menuItem.setEnabled(this.stateMachine.inState(ScanningState.IDLE));
                menuItem.addSelectionListener(this.favoritesSelectListener);
            }
        }
    }

    public static final class Edit
    implements Listener {
        private final FavoritesConfig favoritesConfig;

        public Edit(FavoritesConfig favoritesConfig) {
            this.favoritesConfig = favoritesConfig;
        }

        @Override
        public void handleEvent(Event event) {
            new EditFavoritesDialog(this.favoritesConfig).open();
        }
    }

    public static final class Select
    implements SelectionListener {
        private final FeederGUIRegistry feederRegistry;
        private final FavoritesConfig favoritesConfig;
        private final StartStopScanningAction startStopAction;

        public Select(FavoritesConfig favoritesConfig, FeederGUIRegistry feederRegistry, StartStopScanningAction startStopAction) {
            this.favoritesConfig = favoritesConfig;
            this.feederRegistry = feederRegistry;
            this.startStopAction = startStopAction;
        }

        @Override
        public void widgetSelected(SelectionEvent event) {
            MenuItem menuItem = (MenuItem)event.widget;
            String key = menuItem.getText();
            this.feederRegistry.select(this.favoritesConfig.getFeederId(key));
            this.feederRegistry.current().unserialize(this.favoritesConfig.getSerializedParts(key));
            event.display.getActiveShell().setText(key + " - Angry IP Scanner");
            this.startStopAction.widgetSelected(event);
        }

        @Override
        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    public static final class Add
    implements Listener {
        private final FeederGUIRegistry feederRegistry;
        private final FavoritesConfig favoritesConfig;

        public Add(FavoritesConfig favoritesConfig, FeederGUIRegistry feederRegistry) {
            this.favoritesConfig = favoritesConfig;
            this.feederRegistry = feederRegistry;
        }

        @Override
        public void handleEvent(Event event) {
            Shell activeShell = event.display.getActiveShell();
            String feederInfo = this.feederRegistry.current().getInfo();
            InputDialog inputDialog = new InputDialog(Labels.getLabel("title.favorite.add"), Labels.getLabel("text.favorite.add"));
            String favoriteName = inputDialog.open(feederInfo);
            if (favoriteName != null) {
                if (this.favoritesConfig.get(favoriteName) != null) {
                    throw new UserErrorException("favorite.alreadyExists");
                }
                this.favoritesConfig.add(favoriteName, this.feederRegistry.current());
                activeShell.setText(favoriteName + " - Angry IP Scanner");
            }
        }
    }
}

