/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.config.Version;
import net.azib.ipscan.gui.GettingStartedDialog;
import net.azib.ipscan.gui.actions.HelpMenuActions;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class Startup {
    private Shell shell;
    private GUIConfig guiConfig;
    private HelpMenuActions.CheckVersion checkVersion;

    public Startup(Shell shell, GUIConfig guiConfig, HelpMenuActions.CheckVersion checkVersion) {
        this.shell = shell;
        this.guiConfig = guiConfig;
        this.checkVersion = checkVersion;
    }

    public void onStart() {
        if (this.guiConfig.isFirstRun) {
            Display.getCurrent().asyncExec(() -> {
                GettingStartedDialog dialog = new GettingStartedDialog();
                if (Platform.CRIPPLED_WINDOWS) {
                    dialog.prependText(Labels.getLabel("text.crippledWindowsInfo"));
                }
                this.shell.forceActive();
                dialog.open();
                this.guiConfig.isFirstRun = false;
                this.checkForLatestVersion();
            });
        } else if (!Version.getVersion().equals(this.guiConfig.lastRunVersion)) {
            this.guiConfig.lastRunVersion = Version.getVersion();
        } else if (this.guiConfig.versionCheckEnabled && System.currentTimeMillis() - this.guiConfig.lastVersionCheck > 2592000000L) {
            this.checkForLatestVersion();
        }
    }

    private void checkForLatestVersion() {
        this.checkVersion.check(false);
        this.guiConfig.lastVersionCheck = System.currentTimeMillis();
    }
}

