/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.GUIConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.core.state.ScanningState;
import net.azib.ipscan.core.state.StateMachine;
import net.azib.ipscan.core.state.StateTransitionListener;
import net.azib.ipscan.gui.MainMenu;
import net.azib.ipscan.gui.ResultTable;
import net.azib.ipscan.gui.StatusBar;
import net.azib.ipscan.gui.actions.StartStopScanningAction;
import net.azib.ipscan.gui.actions.ToolsActions;
import net.azib.ipscan.gui.feeders.ControlsArea;
import net.azib.ipscan.gui.feeders.FeederArea;
import net.azib.ipscan.gui.feeders.FeederGUIRegistry;
import net.azib.ipscan.gui.feeders.FeederSelectionCombo;
import net.azib.ipscan.gui.menu.ResultsContextMenu;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MainWindow {
    private final Shell shell;
    private final GUIConfig guiConfig;
    private Composite feederArea;
    private Button startStopButton;
    private Combo feederSelectionCombo;
    private FeederGUIRegistry feederRegistry;
    private StatusBar statusBar;
    private ToolBar prefsButton;
    private ToolBar fetchersButton;

    public MainWindow(Shell shell, GUIConfig guiConfig, FeederArea feederArea, ControlsArea controlsArea, FeederSelectionCombo feederSelectionCombo, Button startStopButton, StartStopScanningAction startStopScanningAction, ResultTable resultTable, StatusBar statusBar, ResultsContextMenu resultsContextMenu, FeederGUIRegistry feederGUIRegistry, StateMachine stateMachine, ToolsActions.Preferences preferencesListener, ToolsActions.ChooseFetchers chooseFetchersListener, MainMenu menuBar) {
        this.shell = shell;
        this.guiConfig = guiConfig;
        this.statusBar = statusBar;
        this.initShell(shell);
        this.initFeederArea(feederArea, feederGUIRegistry);
        this.initControlsArea(controlsArea, feederSelectionCombo, startStopButton, startStopScanningAction, preferencesListener, chooseFetchersListener);
        this.initTableAndStatusBar(resultTable, resultsContextMenu, statusBar);
        shell.setSize(guiConfig.getMainWindowSize());
        shell.open();
        if (guiConfig.isMainWindowMaximized) {
            shell.setMaximized(true);
        }
        stateMachine.addTransitionListener(new EnablerDisabler());
        Display.getCurrent().asyncExec(() -> stateMachine.init());
    }

    private void initShell(Shell shell) {
        shell.setLayout(new FormLayout());
        Image image = new Image((Device)shell.getDisplay(), this.getClass().getResourceAsStream("/images/icon.png"));
        shell.setImage(image);
        shell.addListener(21, event -> this.guiConfig.setMainWindowSize(shell.getSize(), shell.getMaximized()));
    }

    public Shell getShell() {
        return this.shell;
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    private void initTableAndStatusBar(ResultTable resultTable, Menu resultsContextMenu, StatusBar statusBar) {
        resultTable.setLayoutData(LayoutHelper.formData(new FormAttachment(0), new FormAttachment(100), new FormAttachment(this.feederArea), new FormAttachment(statusBar.getComposite())));
        resultTable.setMenu(resultsContextMenu);
    }

    private void initFeederArea(Composite feederArea, FeederGUIRegistry feederRegistry) {
        this.feederArea = feederArea;
        feederArea.setLayoutData(LayoutHelper.formData(new FormAttachment(0), null, new FormAttachment(0), null));
        this.feederRegistry = feederRegistry;
    }

    private void initControlsArea(Composite controlsArea, Combo feederSelectionCombo, Button startStopButton, StartStopScanningAction startStopScanningAction, ToolsActions.Preferences preferencesListener, ToolsActions.ChooseFetchers chooseFetchersListsner) {
        controlsArea.setLayoutData(LayoutHelper.formData(new FormAttachment(this.feederArea), null, new FormAttachment(0), new FormAttachment(this.feederArea, 0, 1024)));
        this.startStopButton = startStopButton;
        this.shell.setDefaultButton(startStopButton);
        startStopButton.pack();
        startStopButton.addSelectionListener(startStopScanningAction);
        startStopButton.setLayoutData(new GridData(768));
        this.feederSelectionCombo = feederSelectionCombo;
        feederSelectionCombo.pack();
        IPFeederSelectionListener feederSelectionListener = new IPFeederSelectionListener();
        feederSelectionCombo.addSelectionListener(feederSelectionListener);
        feederSelectionCombo.select(this.guiConfig.activeFeeder);
        feederSelectionCombo.setToolTipText(Labels.getLabel("combobox.feeder.tooltip"));
        controlsArea.setTabList(new Control[]{startStopButton, feederSelectionCombo});
        this.prefsButton = this.createToolbarButton(controlsArea);
        ToolItem item = new ToolItem(this.prefsButton, 8);
        item.setImage(LayoutHelper.icon("buttons/prefs"));
        item.setToolTipText(Labels.getLabel("title.preferences"));
        item.addListener(13, preferencesListener);
        this.fetchersButton = this.createToolbarButton(controlsArea);
        item = new ToolItem(this.fetchersButton, 8);
        item.setImage(LayoutHelper.icon("buttons/fetchers"));
        item.setToolTipText(Labels.getLabel("title.fetchers"));
        item.addListener(13, chooseFetchersListsner);
        feederSelectionListener.widgetSelected(null);
    }

    private ToolBar createToolbarButton(Composite controlsArea) {
        ToolBar bar = new ToolBar(controlsArea, 0x800000);
        bar.setCursor(bar.getDisplay().getSystemCursor(21));
        return bar;
    }

    private void relayoutControls() {
        Point feederSize = this.feederRegistry.current().getSize();
        Point buttonSize = this.startStopButton.getSize();
        Point comboSize = this.feederSelectionCombo.getSize();
        int sizeDiff = feederSize.y - buttonSize.y - comboSize.y;
        if (sizeDiff >= 0) {
            GridLayout layout = new GridLayout(2, false);
            layout.verticalSpacing = Platform.MAC_OS && sizeDiff == 11 ? 1 : sizeDiff / 3;
            this.startStopButton.getParent().setLayout(layout);
            this.prefsButton.moveAbove(this.startStopButton);
        } else {
            this.startStopButton.getParent().setLayout(new GridLayout(4, false));
            this.startStopButton.moveAbove(this.prefsButton);
        }
    }

    class EnablerDisabler
    implements StateTransitionListener {
        EnablerDisabler() {
        }

        @Override
        public void transitionTo(ScanningState state, StateMachine.Transition transition) {
            if (transition != StateMachine.Transition.START && transition != StateMachine.Transition.COMPLETE) {
                return;
            }
            boolean enabled = state == ScanningState.IDLE;
            MainWindow.this.feederArea.setEnabled(enabled);
            MainWindow.this.feederSelectionCombo.setEnabled(enabled);
            MainWindow.this.prefsButton.setEnabled(enabled);
            MainWindow.this.fetchersButton.setEnabled(enabled);
            MainWindow.this.statusBar.setEnabled(enabled);
        }
    }

    class IPFeederSelectionListener
    extends SelectionAdapter {
        IPFeederSelectionListener() {
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            MainWindow.this.feederRegistry.select(MainWindow.this.feederSelectionCombo.getSelectionIndex());
            Rectangle bounds = MainWindow.this.feederRegistry.current().getBounds();
            FormData feederAreaLayoutData = (FormData)MainWindow.this.feederArea.getLayoutData();
            feederAreaLayoutData.height = bounds.height;
            feederAreaLayoutData.width = bounds.width;
            MainWindow.this.relayoutControls();
            MainWindow.this.shell.layout();
            MainWindow.this.shell.setText(MainWindow.this.feederRegistry.current().getFeederName() + " - Angry IP Scanner");
        }
    }
}

