/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog
extends AbstractModalDialog {
    Label messageLabel;
    Text text;
    Button okButton;
    Button cancelButton;
    private String message;

    public InputDialog(String title, String message) {
        this.populateShell();
        this.shell.setText(title);
        this.messageLabel.setText(message);
        this.messageLabel.pack();
    }

    @Override
    protected void populateShell() {
        Display currentDisplay = Display.getCurrent();
        Shell parent = currentDisplay != null ? currentDisplay.getActiveShell() : null;
        this.shell = new Shell(parent, 67680);
        this.shell.setLayout(LayoutHelper.formLayout(10, 10, 4));
        this.messageLabel = new Label(this.shell, 0);
        this.messageLabel.setLayoutData(LayoutHelper.formData(new FormAttachment(0), null, new FormAttachment(0), null));
        this.text = new Text(this.shell, 2048);
        this.okButton = new Button(this.shell, 0);
        this.okButton.setText(Labels.getLabel("button.OK"));
        this.cancelButton = new Button(this.shell, 0);
        this.cancelButton.setText(Labels.getLabel("button.cancel"));
        this.okButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                InputDialog.this.message = InputDialog.this.text.getText();
                InputDialog.this.shell.dispose();
            }
        });
        this.cancelButton.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                InputDialog.this.message = null;
                InputDialog.this.shell.dispose();
            }
        });
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() | 0x10000000;
    }

    private void setText(String text) {
        text = text != null ? text : "";
        this.text.setText(text);
        this.text.pack();
        this.text.setLayoutData(LayoutHelper.formData(Math.max(this.text.getSize().x, 310), -1, new FormAttachment(0), null, new FormAttachment(this.messageLabel), null));
        this.text.setFocus();
        this.text.setSelection(0, text.length());
    }

    public String open(String text, String okButtonText) {
        this.okButton.setText(okButtonText);
        this.setText(text);
        this.positionButtonsInFormLayout(this.okButton, this.cancelButton, this.text);
        this.shell.pack();
        this.open();
        return this.message;
    }

    public String open(String text) {
        return this.open(text, Labels.getLabel("button.OK"));
    }
}

