/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.FavoritesConfig;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.InputDialog;
import net.azib.ipscan.gui.util.LayoutHelper;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class EditFavoritesDialog
extends AbstractModalDialog {
    private final FavoritesConfig favoritesConfig;
    private List favoritesList;

    public EditFavoritesDialog(FavoritesConfig favoritesConfig) {
        this.favoritesConfig = favoritesConfig;
    }

    @Override
    protected void populateShell() {
        Display currentDisplay = Display.getCurrent();
        Shell parent = currentDisplay != null ? currentDisplay.getActiveShell() : null;
        this.shell = new Shell(parent, 67680);
        this.shell.setText(Labels.getLabel("title.favorite.edit"));
        this.shell.setLayout(LayoutHelper.formLayout(10, 10, 4));
        Label messageLabel = new Label(this.shell, 0);
        messageLabel.setText(Labels.getLabel("text.favorite.edit"));
        this.favoritesList = new List(this.shell, 2562);
        this.favoritesList.setLayoutData(LayoutHelper.formData(330, 200, new FormAttachment(0), null, new FormAttachment(messageLabel), null));
        for (String name : this.favoritesConfig) {
            this.favoritesList.add(name);
        }
        Button upButton = new Button(this.shell, 0);
        upButton.setText(Labels.getLabel("button.up"));
        upButton.addListener(13, new AbstractModalDialog.UpButtonListener(this.favoritesList));
        Button downButton = new Button(this.shell, 0);
        downButton.setText(Labels.getLabel("button.down"));
        downButton.addListener(13, new AbstractModalDialog.DownButtonListener(this.favoritesList));
        Button renameButton = new Button(this.shell, 0);
        renameButton.setText(Labels.getLabel("button.rename"));
        RenameListener renameListener = new RenameListener();
        renameButton.addListener(13, renameListener);
        this.favoritesList.addListener(8, renameListener);
        Button deleteButton = new Button(this.shell, 0);
        deleteButton.setText(Labels.getLabel("button.delete"));
        deleteButton.addListener(13, new DeleteListener());
        upButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.favoritesList), new FormAttachment(renameButton, 0, 131072), new FormAttachment(messageLabel), null));
        downButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.favoritesList), new FormAttachment(renameButton, 0, 131072), new FormAttachment(upButton), null));
        renameButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.favoritesList), null, new FormAttachment(downButton, 10), null));
        deleteButton.setLayoutData(LayoutHelper.formData(new FormAttachment(this.favoritesList), new FormAttachment(renameButton, 0, 131072), new FormAttachment(renameButton), null));
        Button okButton = new Button(this.shell, 0);
        okButton.setText(Labels.getLabel("button.OK"));
        Button cancelButton = new Button(this.shell, 0);
        cancelButton.setText(Labels.getLabel("button.cancel"));
        this.positionButtonsInFormLayout(okButton, cancelButton, this.favoritesList);
        this.shell.pack();
        okButton.addListener(13, e -> {
            this.saveFavorites();
            this.close();
        });
        cancelButton.addListener(13, e -> this.close());
    }

    private void saveFavorites() {
        this.favoritesConfig.update(this.favoritesList.getItems());
        this.favoritesConfig.store();
    }

    class RenameListener
    implements Listener {
        RenameListener() {
        }

        @Override
        public void handleEvent(Event event) {
            String oldName;
            if (EditFavoritesDialog.this.favoritesConfig.size() == 0) {
                return;
            }
            int index = Math.max(EditFavoritesDialog.this.favoritesList.getSelectionIndex(), 0);
            InputDialog prompt = new InputDialog(Labels.getLabel("title.rename"), "");
            String newName = prompt.open(oldName = EditFavoritesDialog.this.favoritesList.getItem(index));
            if (newName != null) {
                EditFavoritesDialog.this.favoritesConfig.add(newName, EditFavoritesDialog.this.favoritesConfig.remove(oldName));
                EditFavoritesDialog.this.favoritesList.setItem(index, newName);
            }
            EditFavoritesDialog.this.favoritesList.forceFocus();
        }
    }

    class DeleteListener
    implements Listener {
        DeleteListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EditFavoritesDialog.this.favoritesList.remove(EditFavoritesDialog.this.favoritesList.getSelectionIndices());
        }
    }
}

