/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.gui;

import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.Version;
import net.azib.ipscan.gui.AbstractModalDialog;
import net.azib.ipscan.gui.actions.BrowserLauncher;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AboutDialog
extends AbstractModalDialog {
    @Override
    protected void populateShell() {
        this.shell.setText(Labels.getLabel("title.about"));
        this.shell.setSize(new Point(500, 393));
        Label iconLabel = new Label(this.shell, 1);
        iconLabel.setLocation(10, 10);
        if (this.shell.getImage() != null) {
            iconLabel.setImage(this.shell.getImage());
        }
        iconLabel.pack();
        int leftBound = iconLabel.getBounds().width + 20;
        String aboutText = Labels.getLabel("text.about").replace("%NAME", "Angry IP Scanner").replace("%VERSION", Version.getVersion()).replace("%DATE", Version.getBuildDate()).replace("%COPYLEFT", "\u00a9 2022 Anton Keks and contributors");
        Text aboutLabel = new Text(this.shell, 10);
        aboutLabel.setBackground(this.shell.getBackground());
        aboutLabel.setText(aboutText);
        aboutLabel.setLocation(leftBound, 10);
        aboutLabel.pack();
        Label websiteLabel = this.createLinkLabel("https://angryip.org", "https://angryip.org");
        websiteLabel.setLocation(leftBound, 10 + aboutLabel.getBounds().height);
        String systemText = Labels.getLabel("text.about.system").replace("%JAVA", System.getProperty("java.vm.vendor") + " " + System.getProperty("java.runtime.version")).replace("%OS", System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")").replace("%SWT", SWT.getPlatform() + " " + SWT.getVersion());
        Text systemLabel = new Text(this.shell, 10);
        systemLabel.setBackground(this.shell.getBackground());
        systemLabel.setText(systemText);
        systemLabel.setLocation(leftBound, 20 + aboutLabel.getBounds().height + websiteLabel.getBounds().height);
        systemLabel.pack();
        Button button = this.createCloseButton();
        Text licenseText = new Text(this.shell, 2634);
        licenseText.setBounds(leftBound, systemLabel.getBounds().y + systemLabel.getBounds().height + 10, this.shell.getClientArea().width - leftBound - 10, button.getLocation().y - systemLabel.getBounds().y - systemLabel.getBounds().height - 20);
        licenseText.setBackground(this.shell.getDisplay().getSystemColor(25));
        licenseText.setText("Licensed under the GNU General Public License Version 2\n\nAngry IP Scanner is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.\n\nAngry IP Scanner is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.");
        Label fullLicenseLabel = this.createLinkLabel("Full license", "http://www.gnu.org/licenses/gpl-2.0.html");
        fullLicenseLabel.setLocation(leftBound, licenseText.getBounds().y + licenseText.getBounds().height + 10);
        Label privacyLabel = this.createLinkLabel("Privacy", "https://angryip.org/about/privacy.html");
        privacyLabel.setLocation(leftBound + privacyLabel.getBounds().width + 40, fullLicenseLabel.getBounds().y);
    }

    @Override
    protected int getShellStyle() {
        return super.getShellStyle() | 0x10000000;
    }

    private Label createLinkLabel(String text, String url) {
        Label link = new Label(this.shell, 0);
        link.setForeground(this.shell.getDisplay().getSystemColor(36));
        link.setCursor(this.shell.getDisplay().getSystemCursor(21));
        link.setText(text);
        link.addListener(4, event -> BrowserLauncher.openURL(url));
        link.pack();
        return link;
    }
}

