/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.fetchers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningResult;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.fetchers.AbstractFetcher;
import net.azib.ipscan.fetchers.FetcherPrefs;
import net.azib.ipscan.gui.fetchers.PortTextFetcherPrefs;

public abstract class PortTextFetcher
extends AbstractFetcher {
    private static final Logger LOG = LoggerFactory.getLogger();
    private ScannerConfig scannerConfig;
    private int defaultPort;
    protected boolean scanOpenPorts;
    protected String textToSend;
    protected Pattern matchingRegexp;
    protected int extractGroup;

    public PortTextFetcher(ScannerConfig scannerConfig, int defaultPort, String defaultTextToSend, String matchingRegexp) {
        this.scannerConfig = scannerConfig;
        this.defaultPort = defaultPort;
        this.textToSend = this.getPreferences().get("textToSend", defaultTextToSend);
        this.matchingRegexp = Pattern.compile(this.getPreferences().get("matchingRegexp", matchingRegexp));
        this.extractGroup = this.getPreferences().getInt("extractGroup", 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object scan(ScanningSubject subject) {
        Iterator<Integer> portIterator = this.getPortIterator(subject);
        block11: while (portIterator.hasNext()) {
            if (Thread.currentThread().isInterrupted()) return null;
            try (Socket socket2 = new Socket();){
                String line;
                Matcher matcher;
                socket2.connect(new InetSocketAddress(subject.getAddress(), (int)portIterator.next()), subject.getAdaptedPortTimeout());
                socket2.setTcpNoDelay(true);
                socket2.setSoTimeout(this.scannerConfig.portTimeout * 2);
                socket2.setSoLinger(true, 0);
                socket2.getOutputStream().write(this.textToSend.getBytes());
                BufferedReader in = new BufferedReader(new InputStreamReader(socket2.getInputStream()));
                do {
                    if ((line = in.readLine()) == null) continue block11;
                } while (!(matcher = this.matchingRegexp.matcher(line)).find());
                subject.setResultType(ScanningResult.ResultType.WITH_PORTS);
                String string = this.getResult(matcher, socket2.getPort());
                return string;
            }
            catch (ConnectException socket2) {
            }
            catch (SocketTimeoutException socket2) {
            }
            catch (SocketException socket2) {
            }
            catch (IOException e) {
                LOG.log(Level.FINE, subject.getAddress().toString(), e);
            }
        }
        return null;
    }

    protected String getResult(Matcher matcher, int port) {
        String result = matcher.group(this.extractGroup);
        return result.isEmpty() ? String.valueOf(port) : result;
    }

    private Iterator<Integer> getPortIterator(ScanningSubject subject) {
        SortedSet openPorts;
        if (this.scanOpenPorts && (openPorts = (SortedSet)subject.getParameter("openPorts")) != null) {
            TreeSet<Integer> ports = new TreeSet<Integer>(openPorts);
            ports.add(this.defaultPort);
            return ports.iterator();
        }
        return subject.isAnyPortRequested() ? subject.requestedPortsIterator() : Collections.singleton(this.defaultPort).iterator();
    }

    @Override
    public Class<? extends FetcherPrefs> getPreferencesClass() {
        return PortTextFetcherPrefs.class;
    }

    public String getTextToSend() {
        return this.textToSend;
    }

    public void setTextToSend(String textToSend) {
        this.textToSend = textToSend;
    }

    public Pattern getMatchingRegexp() {
        return this.matchingRegexp;
    }

    public void setMatchingRegexp(Pattern matchingRegexp) {
        this.matchingRegexp = matchingRegexp;
    }

    public int getExtractGroup() {
        return this.extractGroup;
    }

    public void setExtractGroup(int extractGroup) {
        this.extractGroup = extractGroup;
    }
}

