/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.feeders;

import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.feeders.Feeder;
import net.azib.ipscan.util.InetAddressUtils;

public abstract class AbstractFeeder
implements Feeder {
    private NetworkInterface netIf;
    private InterfaceAddress ifAddr;

    protected void initInterfaces(InetAddress ip) {
        this.netIf = InetAddressUtils.getInterface(ip);
        this.ifAddr = InetAddressUtils.matchingAddress(this.netIf, ip.getClass());
    }

    @Override
    public ScanningSubject subject(InetAddress ip) {
        return new ScanningSubject(ip, this.netIf, this.ifAddr);
    }

    @Override
    public String getName() {
        return Labels.getLabel(this.getId());
    }

    @Override
    public boolean isLocalNetwork() {
        return this.ifAddr != null;
    }

    public String toString() {
        return this.getName() + ": " + this.getInfo();
    }
}

