/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.exporters;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.azib.ipscan.config.Version;
import net.azib.ipscan.exporters.AbstractExporter;
import net.azib.ipscan.exporters.ExporterException;
import net.azib.ipscan.exporters.IPListExporter;

public class XMLExporter
extends AbstractExporter {
    private int ipFetcherIndex;
    private String[] fetcherNames;

    @Override
    public String getId() {
        return "exporter.xml";
    }

    @Override
    public String getFilenameExtension() {
        return "xml";
    }

    @Override
    public void shouldAppendTo(File file) {
        throw new ExporterException("xml.noAppend");
    }

    @Override
    public void start(OutputStream outputStream, String feederInfo) throws IOException {
        this.output = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        this.output.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
        this.output.println("<!-- This file has been generated by " + Version.getFullName() + " -->");
        this.output.println("<!-- Visit the website at https://angryip.org -->");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        this.output.println("<scanning_report time=\"" + sdf.format(new Date()) + "\">");
        int colonPos = feederInfo.indexOf(58);
        String feederName = null;
        if (colonPos >= 0) {
            feederName = feederInfo.substring(0, colonPos);
            feederInfo = feederInfo.substring(colonPos + 1);
        }
        this.output.print("\t<feeder" + (String)(feederName != null ? " name=\"" + feederName.trim() + "\"" : "") + ">");
        this.output.print("<![CDATA[" + feederInfo.trim() + "]]>");
        this.output.println("</feeder>");
        this.output.println("\t<hosts>");
    }

    @Override
    public void end() throws IOException {
        this.output.println("\t</hosts>");
        this.output.println("</scanning_report>");
        if (this.output.checkError()) {
            throw new IOException();
        }
    }

    @Override
    public void setFetchers(String[] fetcherNames) throws IOException {
        this.ipFetcherIndex = IPListExporter.findFetcherById("fetcher.ip", fetcherNames);
        this.fetcherNames = fetcherNames;
    }

    @Override
    public void nextAddressResults(Object[] results) throws IOException {
        this.output.println("\t\t<host address=\"" + results[this.ipFetcherIndex] + "\">");
        for (int i = 0; i < results.length; ++i) {
            if (results[i] == null) continue;
            this.output.println("\t\t\t<result name=\"" + this.fetcherNames[i] + "\"><![CDATA[" + results[i] + "]]></result>");
        }
        this.output.println("\t\t</host>");
    }
}

