/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan.core.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.ScannerConfig;
import net.azib.ipscan.core.ScanningSubject;
import net.azib.ipscan.core.net.PingResult;
import net.azib.ipscan.core.net.Pinger;
import net.azib.ipscan.util.IOUtils;

public class TCPPinger
implements Pinger {
    private static final Logger LOG = LoggerFactory.getLogger();
    private static final int[] PROBE_TCP_PORTS = new int[]{80, 7, 443, 139, 22};
    private int timeout;

    public TCPPinger(ScannerConfig config) {
        this.timeout = config.pingTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PingResult ping(ScanningSubject subject, int count) {
        PingResult result = new PingResult(subject.getAddress(), count);
        int workingPort = -1;
        for (int i = 0; i < count && !Thread.currentThread().isInterrupted(); ++i) {
            int probePort;
            Socket socket = new Socket();
            int n = probePort = workingPort >= 0 ? workingPort : PROBE_TCP_PORTS[i % PROBE_TCP_PORTS.length];
            if (i == 0 && subject.isAnyPortRequested()) {
                probePort = subject.requestedPortsIterator().next();
            }
            long startTime = System.currentTimeMillis();
            try {
                socket.setReuseAddress(true);
                socket.setReceiveBufferSize(32);
                int timeout = result.isTimeoutAdaptationAllowed() ? Math.min(result.getLongestTime() * 2, this.timeout) : this.timeout;
                socket.connect(new InetSocketAddress(subject.getAddress(), probePort), timeout);
                if (!socket.isConnected()) continue;
                this.success(result, startTime);
                workingPort = probePort;
                continue;
            }
            catch (SocketTimeoutException timeout) {
                continue;
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (msg.contains("refused")) {
                    this.success(result, startTime);
                    continue;
                }
                if (e instanceof NoRouteToHostException || msg.contains("route to host") || msg.contains("down") || msg.contains("unreachable") || msg.contains("closed") || msg.contains("Invalid argument")) break;
                LOG.log(Level.INFO, subject.toString(), e);
                continue;
            }
            finally {
                IOUtils.closeQuietly(socket);
            }
        }
        return result;
    }

    private void success(PingResult result, long startTime) {
        result.addReply(System.currentTimeMillis() - startTime);
        result.enableTimeoutAdaptation();
    }
}

