/*
 * Decompiled with CFR 0.152.
 */
package net.azib.ipscan;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Security;
import java.util.Locale;
import java.util.logging.Logger;
import net.azib.ipscan.config.CommandLineProcessor;
import net.azib.ipscan.config.ComponentRegistry;
import net.azib.ipscan.config.Config;
import net.azib.ipscan.config.Labels;
import net.azib.ipscan.config.LoggerFactory;
import net.azib.ipscan.config.Platform;
import net.azib.ipscan.di.Injector;
import net.azib.ipscan.gui.GUI;
import net.azib.ipscan.gui.InfoDialog;
import net.azib.ipscan.gui.MacApplicationMenu;

public class Main {
    static final Logger LOG = LoggerFactory.getLogger();

    public static void main(String ... args) {
        GUI gui = null;
        try {
            long startTime = System.currentTimeMillis();
            gui = new GUI();
            Main.disableDNSCache();
            Locale locale = Config.getConfig().getLocale();
            Labels.initialize(locale);
            LOG.finer("Labels and Config initialized after " + (System.currentTimeMillis() - startTime));
            Injector injector = new ComponentRegistry().init();
            if (Platform.MAC_OS) {
                injector.require(MacApplicationMenu.class);
            }
            LOG.finer("Components initialized after " + (System.currentTimeMillis() - startTime));
            Main.processCommandLine(args, injector);
            gui.showMainWindow(injector, args.length == 0);
            Config.getConfig().store();
            gui.close();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            Main.showFallbackError("Failed to load native code for Java " + System.getProperty("java.runtime.version") + " on " + System.getProperty("os.arch") + "\nProbably you are using a binary built for wrong OS or CPU.\n\n" + e.getMessage());
            if (Platform.MAC_OS) {
                try {
                    Files.walk(Path.of(System.getProperty("user.home"), ".swt", "lib"), new FileVisitOption[0]).map(Path::toFile).forEach(File::delete);
                }
                catch (Exception exception) {}
            }
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            Main.showFallbackError("SWT GUI toolkit not available: " + e + "\n\nIf you are using platform-neutral build, make sure you provide SWT built for your platform manually (e.g. install libswt packages), or please use a platform specific binary.");
        }
        catch (Throwable e) {
            Main.handleFatalError(gui, e);
        }
    }

    private static void handleFatalError(GUI gui, Throwable e) {
        e.printStackTrace();
        if (gui != null) {
            gui.showMessage(0, "Fatal Error", e + "\nPlease submit a bug report mentioning your OS and what exactly were you doing.");
        } else {
            Main.showFallbackError(e.getMessage());
        }
    }

    private static void showFallbackError(String message) {
        try {
            System.err.println(message);
            try {
                Files.writeString(Path.of(System.getProperty("user.home"), ".swt", "ipscan-crash.txt"), (CharSequence)message, new OpenOption[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Platform.MAC_OS) {
                Runtime.getRuntime().exec(new String[]{"osascript", "-e", "display notification \"" + message + "\" with title \"Angry IP Scanner\""});
            } else {
                Class.forName("javax.swing.JOptionPane").getMethod("showMessageDialog", Class.forName("java.awt.Component"), Object.class).invoke(null, null, message);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private static void disableDNSCache() {
        Security.setProperty("networkaddress.cache.ttl", "0");
        Security.setProperty("networkaddress.cache.negative.ttl", "0");
    }

    private static void processCommandLine(String[] args, Injector injector) {
        if (args.length != 0) {
            CommandLineProcessor cli = injector.require(CommandLineProcessor.class);
            try {
                cli.parse(args);
            }
            catch (Exception e) {
                Main.showMessageToConsole(e.getMessage() + "\n\n" + cli);
                System.exit(1);
            }
        }
    }

    private static void showMessageToConsole(String usageText) {
        if (System.console() != null) {
            System.err.println(usageText);
        } else {
            InfoDialog dialog = new InfoDialog("Angry IP Scanner", Labels.getLabel("title.commandline"));
            dialog.setMessage(usageText);
            dialog.open();
        }
    }
}

