/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster.gui.tableModels;

import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.gui.tableModels.ErrorTableObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ErrorTableModel
extends AbstractTableModel {
    String start = "<html><font color=\"red\">";
    String end = "</font></html>";
    private String[] columnNames = new String[]{new String("Request"), new String("Error Message")};
    private Vector<ErrorTableObject> data;
    private JTable table;
    Manager manager = Manager.getInstance();

    public ErrorTableModel(JTable table) {
        this.table = table;
        this.data = this.manager.errors;
    }

    public void setColumnName(int index, String name) {
        if (index < this.columnNames.length) {
            this.columnNames[index] = name;
        }
    }

    public String getColumnName(int col) {
        return this.columnNames[col];
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.data.size()) {
            return null;
        }
        if (col == 0) {
            return this.start + this.data.elementAt(row).getUrl().toString() + this.end;
        }
        if (col == 1) {
            return this.start + this.data.elementAt(row).getReason() + this.end;
        }
        return null;
    }

    public void addRow(ErrorTableObject object) {
        if (!this.data.contains(object)) {
            this.data.addElement(object);
            if (this.table.getRowSorter() != null) {
                int location = this.table.getRowSorter().convertRowIndexToView(this.data.size() - 1);
                if (location > 0) {
                    this.fireTableRowsInserted(location - 1, location - 1);
                } else {
                    this.fireTableDataChanged();
                }
            } else {
                this.fireTableDataChanged();
            }
        } else {
            return;
        }
    }

    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public void clearAllResults() {
        this.data.removeAllElements();
        this.fireTableDataChanged();
    }
}

