/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import net.cqure.exceptions.AuditRuleException;

public class AuditRule {
    private final int ACTION_IGNORE = 1000;
    private final int ACTION_LOCKED = 1001;
    private final int ACTION_ABORT = 1002;
    private final int ACTION_PRINT = 1003;
    private int m_nErrorCode = -1;
    private int m_nAction = -1;

    public AuditRule(int nErrorCode, String strAction) throws AuditRuleException {
        this.m_nErrorCode = nErrorCode;
        this.m_nAction = this.actionStringToInt(strAction);
    }

    private int actionStringToInt(String strAction) throws AuditRuleException {
        if (strAction.equalsIgnoreCase("IGNORE")) {
            return 1000;
        }
        if (strAction.equalsIgnoreCase("ABORT")) {
            return 1002;
        }
        if (strAction.equalsIgnoreCase("LOCKED")) {
            return 1001;
        }
        if (strAction.equalsIgnoreCase("PRINT")) {
            return 1003;
        }
        throw new AuditRuleException("Unknown action: " + strAction);
    }

    public boolean isMatch(int nError) {
        return nError == this.m_nErrorCode;
    }

    private boolean isAction(int nAction) {
        return this.m_nAction == nAction;
    }

    public boolean isIgnore() {
        return this.isAction(1000);
    }

    public boolean isLocked() {
        return this.isAction(1001);
    }

    public boolean isAbort() {
        return this.isAction(1002);
    }

    public boolean isPrint() {
        return this.isAction(1003);
    }

    public boolean isCatchAll() {
        return -1 == this.m_nErrorCode;
    }

    public String toString() {
        return String.valueOf(this.m_nErrorCode) + "," + this.m_nAction;
    }
}

