/*
 * Decompiled with CFR 0.152.
 */
package net.cqure;

import java.util.Vector;

public class AuditObject {
    public static final int STATUS_INITIALIZED = 1001;
    public static final int STATUS_READY = 1002;
    public static final int STATUS_RUNNING = 1003;
    public static final int STATUS_COMPLETED = 1004;
    public static final int STATUS_ABORTED = 1005;
    public static final int STATUS_SCHEDULED = 1006;
    public static final int PASSWORD_UNKNOWN = 2001;
    public static final int PASSWORD_FOUND = 2002;
    public static final int PASSWORD_LOCKED = 2003;
    private String m_strUsername = "";
    private Vector<String> m_oPasswords = null;
    private int m_nPasswordIndex = -1;
    private int m_nStatus = 1001;
    private int m_nMaxGuesses = -1;
    private int m_nPassStatus = 2001;

    public AuditObject(String strUsername, Vector<String> oPasswords) {
        this.m_strUsername = strUsername;
        this.m_oPasswords = oPasswords;
        this.m_nStatus = 1002;
    }

    public void setUsername(String strUsername) {
        this.m_strUsername = strUsername;
    }

    public String getUsername() {
        return this.m_strUsername;
    }

    public void setPassword(Vector<String> oPasswords) {
        this.m_oPasswords = oPasswords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPasswordFound() {
        Class<AuditObject> clazz = AuditObject.class;
        synchronized (AuditObject.class) {
            block4: {
                if (2002 != this.m_nPassStatus) break block4;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return false;
        }
    }

    public String getFoundPassword() {
        if (!this.isPasswordFound()) {
            return null;
        }
        if (this.m_oPasswords.get(this.m_nPasswordIndex).equalsIgnoreCase("%username%")) {
            return this.m_strUsername;
        }
        if (this.m_oPasswords.get(this.m_nPasswordIndex).equalsIgnoreCase("lc %username%")) {
            return this.m_strUsername.toLowerCase();
        }
        return this.m_oPasswords.get(this.m_nPasswordIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorrectPassword() {
        Class<AuditObject> clazz = AuditObject.class;
        synchronized (AuditObject.class) {
            this.m_nStatus = 1004;
            this.m_nPassStatus = 2002;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccountLocked() {
        Class<AuditObject> clazz = AuditObject.class;
        synchronized (AuditObject.class) {
            this.m_nStatus = 1004;
            this.m_nPassStatus = 2003;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getNextPassword() {
        if (this.m_nMaxGuesses > 0 && this.m_nMaxGuesses < this.m_nPasswordIndex) {
            this.setStatus(1004);
        }
        if (this.m_oPasswords.size() - 1 == this.m_nPasswordIndex) {
            this.setStatus(1004);
            return null;
        }
        if (this.m_oPasswords.size() - 1 > this.m_nPasswordIndex) {
            ++this.m_nPasswordIndex;
            if (this.m_oPasswords.get(this.m_nPasswordIndex).equalsIgnoreCase("%username%")) {
                return this.m_strUsername;
            }
            if (this.m_oPasswords.get(this.m_nPasswordIndex).equalsIgnoreCase("lc %username%")) {
                return this.m_strUsername.toLowerCase();
            }
            return this.m_oPasswords.get(this.m_nPasswordIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasStatus(int nStatus) {
        Class<AuditObject> clazz = AuditObject.class;
        synchronized (AuditObject.class) {
            block4: {
                if (this.m_nStatus != nStatus) break block4;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    public boolean isReady() {
        return this.hasStatus(1002);
    }

    public boolean isCompleted() {
        return this.hasStatus(1004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatus(int nStatus) {
        Class<AuditObject> clazz = AuditObject.class;
        synchronized (AuditObject.class) {
            if (1004 != this.m_nStatus) {
                this.m_nStatus = nStatus;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setRunning() {
        this.setStatus(1003);
    }

    public void setReady() {
        this.setStatus(1002);
    }

    public void setScheduled() {
        this.setStatus(1006);
    }

    public void setCompleted() {
        this.setStatus(1004);
    }

    public boolean isRunning() {
        return this.hasStatus(1003);
    }

    public String toString() {
        String strPass = this.getFoundPassword();
        if (strPass == null) {
            strPass = "<unknown>";
        }
        if (2001 == this.m_nPassStatus) {
            return null;
        }
        String str = "user: " + this.getUsername() + "\tpass: " + strPass;
        if (2003 == this.m_nPassStatus) {
            str = String.valueOf(str) + " (locked)";
        }
        return str;
    }

    public int getGuessCount() {
        return this.m_nPasswordIndex + 1;
    }
}

