/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester.report;

import java.io.File;
import java.io.IOException;
import org.owasp.csrftester.CSRFTesterModel;
import org.owasp.csrftester.report.ReportAdapter;

public final class FormsReport
extends ReportAdapter {
    protected FormsReport() {
    }

    @Override
    public String generateHtml(CSRFTesterModel model, File dir) throws IOException {
        int formCount = this.getFormCount(model);
        String formHtml = this.getFormHtml(model);
        String content = this.getContent("/resources/FormsTemplate.html");
        String pauseHtml = this.getPauseHtml(model);
        content = content.replace("<%PAUSES%>", pauseHtml);
        content = content.replace("<%COUNT%>", String.valueOf(formCount));
        content = content.replace("<%FORMS%>", formHtml);
        this.writeFile(dir, "index.html", content);
        return "file://" + dir.getPath() + "/index.html";
    }

    private int getFormCount(CSRFTesterModel model) {
        return model.getRowCount();
    }

    private String getFormHtml(CSRFTesterModel model) {
        StringBuffer sb = new StringBuffer();
        int count = model.getRowCount();
        int i = 0;
        while (i < count) {
            sb.append("<form method=\"" + model.getMethod(i) + "\" name=\"form" + i + "\" action=\"" + model.getURL(i) + "\">\r\n");
            sb.append(this.getParametersAsHtmlInput(model, i));
            sb.append("</form>\r\n");
            ++i;
        }
        return sb.toString();
    }

    private String getPauseHtml(CSRFTesterModel model) {
        StringBuffer pauses = new StringBuffer();
        int count = model.getRowCount();
        int i = 0;
        while (i < count) {
            pauses.append("\"" + model.getPause(i) + "\"");
            if (i != count - 1) {
                pauses.append(",");
            }
            ++i;
        }
        return pauses.toString();
    }
}

