/*
 * Decompiled with CFR 0.152.
 */
package satDomain;

import bindead.debug.Benchmark;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import satDomain.AffineSatDomain;
import satDomain.Config;
import satDomain.Flag;
import satDomain.HashedSubstitution;
import satDomain.Renamer;
import satDomain.Substitution;

public class Numeric {
    public final AffineSatDomain internal;
    private final Set<Integer> attic;

    public Numeric() {
        this.internal = new AffineSatDomain();
        this.attic = new HashSet<Integer>();
    }

    public Numeric(Numeric other) {
        this.internal = other.internal.copy();
        this.attic = new HashSet<Integer>(other.attic);
    }

    public Numeric assertNonzero(Flag f) {
        Numeric temp = new Numeric(this);
        temp.assumeFalse(f);
        if (temp.isBottom()) {
            temp = null;
        }
        return temp;
    }

    public void assumeAllFalse(Collection<Flag> collection) {
        for (Flag f : collection) {
            this.assumeFalse(f);
        }
    }

    public void assumeEqual(Flag flag, Flag to) {
        this.assumeEqual(flag.flag, to.flag);
    }

    public void assumeEqual(int flag, int to) {
        this.internal.assumeEquality(flag, to);
    }

    public void assumeExactCount(Flag nonZero, Collection<Flag> collection) {
        if (Config.useRefcount) {
            int[] cls = new int[collection.size() + 1];
            cls[0] = -nonZero.flag;
            int i = 1;
            for (Flag f : collection) {
                cls[i++] = f.flag;
            }
            this.internal.assumeClause(cls);
        }
    }

    public void assumeFalse(Flag f) {
        this.internal.assumeTrue(-f.flag);
    }

    public void assumeNotAllFalse(Collection<Flag> pts) {
        int[] cls = new int[pts.size()];
        int i = 0;
        for (Flag f : pts) {
            cls[i++] = f.flag;
        }
        this.internal.assumeClause(cls);
    }

    public void assumeOnlyOne(Flag e, Flag ce) {
        this.internal.assumeClause(new int[]{-e.flag, -ce.flag});
    }

    public void assumeSaturatedSum(Flag x1, Flag x0, Flag y0, Flag s1, Flag s0) {
        this.internal.assumeTwoBitSum(x1.flag, x0.flag, y0.flag, s1.flag, s0.flag);
    }

    public void assumeTrue(Flag f) {
        this.internal.assumeTrue(f.flag);
    }

    public Flag duplicate(Flag flag) {
        return new Flag(this.internal.duplicate(flag.flag));
    }

    public Substitution expand(String reason, Collection<Flag> fromSet) {
        HashSet<Integer> f2 = new HashSet<Integer>();
        for (Flag f : fromSet) {
            f2.add(f.flag);
        }
        f2.addAll(this.attic);
        Substitution r = this.internal.expand(reason, f2);
        HashSet<Integer> attic2 = new HashSet<Integer>(this.attic);
        for (Integer i : attic2) {
            this.attic.add(r.get(i));
        }
        Benchmark.count("expand with attic size " + this.attic.size(), 1);
        return r;
    }

    public Flag freshFalseVar() {
        return new Flag(this.internal.freshFalseVar());
    }

    public Flag freshTopVar() {
        return new Flag(this.internal.freshTopVar());
    }

    public Flag freshTrueVar() {
        return new Flag(this.internal.freshTrueVar());
    }

    public int getLastVar() {
        return this.internal.getLastVar();
    }

    public boolean isBottom() {
        return this.internal.isUnsatisfiable();
    }

    public boolean isSubset(Numeric other) {
        assert (this.getLastVar() == other.getLastVar());
        return this.internal.isSubset(other.internal);
    }

    public void joinWith(Numeric other) {
        this.internal.joinWith(other.internal);
    }

    public void moveToAttic(Flag f) {
        if (f != null) {
            this.attic.add(f.flag);
        }
    }

    public void project(Renamer renamer, boolean withCompression) {
        this.internal.project(renamer, withCompression);
        this.attic.clear();
    }

    public void setToBottom() {
        this.internal.assumeUnsatisfiable();
    }

    public String showFlag(Flag f) {
        return this.internal.showFlag(f.flag);
    }

    public Substitution summarize(HashedSubstitution subst) {
        int discr = this.freshTopVar().flag;
        HashedSubstitution newS = new HashedSubstitution();
        for (Map.Entry<Integer, Integer> e : subst.entries()) {
            int a = e.getKey();
            int b = e.getValue();
            ((Substitution)newS).put(b, this.internal.summarize(discr, a, b));
        }
        return newS;
    }

    public String toDetailedString() {
        return this.internal.toDetailedString();
    }

    public String toString() {
        String s = "Attic: " + this.attic.toString() + "\n";
        return s + this.internal.toString();
    }

    public void rename(Map<Integer, Integer> renamer) {
        this.internal.rename(renamer);
        Numeric.renameAttic(renamer);
    }

    private static void renameAttic(Map<Integer, Integer> renamer) {
        if (renamer.size() == 0) {
            return;
        }
        assert (false);
    }

    public void assumeClauses(List<int[]> clauses) {
        this.internal.assumeClauses(clauses);
    }
}

