/*
 * Decompiled with CFR 0.152.
 */
package satDomain;

import java.util.Arrays;
import java.util.Collection;
import org.sat4j.core.VecInt;
import satDomain.Substitution;

public class Clause {
    final int[] clause;

    Clause(Clause other) {
        int[] oc = other.getClause();
        this.clause = Arrays.copyOf(oc, oc.length);
    }

    public Clause(int[] clause) {
        this.clause = clause;
    }

    Clause append(int v) {
        int[] cls = Arrays.copyOf(this.clause, this.clause.length + 1);
        cls[this.clause.length] = v;
        return new Clause(cls);
    }

    public int[] getClause() {
        return this.clause;
    }

    Clause mergeVars(int to, int from) {
        int[] cl = new int[this.clause.length];
        for (int i = 0; i < this.clause.length; ++i) {
            int v = this.clause[i];
            cl[i] = v == from ? to : (v == -from ? -to : v);
        }
        return new Clause(cl);
    }

    Clause renamedClause(Substitution subst) {
        int[] cl = new int[this.clause.length];
        for (int i = 0; i < this.clause.length; ++i) {
            cl[i] = subst.newValue(this.clause[i]);
        }
        return new Clause(cl);
    }

    public String toString() {
        String res = "";
        String sep = "";
        for (int element : this.clause) {
            res = res + sep + element;
            sep = " ";
        }
        res = res + " 0\n";
        return res;
    }

    boolean containsAnyOf(Collection<Integer> fromSet) {
        for (int element : this.clause) {
            if (!fromSet.contains(Math.abs(element))) continue;
            return true;
        }
        return false;
    }

    String showDisjunction() {
        String res = "";
        String sep = "";
        for (int element : this.clause) {
            assert (element != 0);
            String elm = "x" + Math.abs(element);
            res = res + sep + (element > 0 ? " " + elm : "!" + elm);
            sep = " ";
        }
        return res;
    }

    VecInt toVecInt() {
        assert (this.allNonzero());
        return new VecInt(this.clause);
    }

    private boolean allNonzero() throws Error {
        for (int i : this.clause) {
            if (i != 0) continue;
            return false;
        }
        return true;
    }
}

